package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  BuiltInsMaxResults,
  LocaleId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBuiltInSlotTypesRequest(
    localeId: LocaleId,
    sortBy: Option[zio.aws.lexmodelsv2.model.BuiltInSlotTypeSortBy] = None,
    maxResults: Option[BuiltInsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest = {
    import ListBuiltInSlotTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest
      .builder()
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => BuiltInsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesRequest.wrap(buildAwsValue())
}
object ListBuiltInSlotTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesRequest =
      zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesRequest(
        localeId,
        sortBy.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def localeId: LocaleId
    def sortBy: Option[zio.aws.lexmodelsv2.model.BuiltInSlotTypeSortBy.ReadOnly]
    def maxResults: Option[BuiltInsMaxResults]
    def nextToken: Option[NextToken]
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BuiltInSlotTypeSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, BuiltInsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest
  ) extends zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesRequest.ReadOnly {
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val sortBy
        : Option[zio.aws.lexmodelsv2.model.BuiltInSlotTypeSortBy.ReadOnly] =
      scala
        .Option(impl.sortBy())
        .map(value =>
          zio.aws.lexmodelsv2.model.BuiltInSlotTypeSortBy.wrap(value)
        )
    override val maxResults: Option[BuiltInsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.BuiltInsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest
  ): zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesRequest.ReadOnly =
    new Wrapper(impl)
}
