package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Message(
    plainTextMessage: Option[zio.aws.lexmodelsv2.model.PlainTextMessage] = None,
    customPayload: Option[zio.aws.lexmodelsv2.model.CustomPayload] = None,
    ssmlMessage: Option[zio.aws.lexmodelsv2.model.SSMLMessage] = None,
    imageResponseCard: Option[zio.aws.lexmodelsv2.model.ImageResponseCard] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.Message
      .builder()
      .optionallyWith(plainTextMessage.map(value => value.buildAwsValue()))(
        _.plainTextMessage
      )
      .optionallyWith(customPayload.map(value => value.buildAwsValue()))(
        _.customPayload
      )
      .optionallyWith(ssmlMessage.map(value => value.buildAwsValue()))(
        _.ssmlMessage
      )
      .optionallyWith(imageResponseCard.map(value => value.buildAwsValue()))(
        _.imageResponseCard
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.Message.ReadOnly =
    zio.aws.lexmodelsv2.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.Message
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.Message =
      zio.aws.lexmodelsv2.model.Message(
        plainTextMessage.map(value => value.asEditable),
        customPayload.map(value => value.asEditable),
        ssmlMessage.map(value => value.asEditable),
        imageResponseCard.map(value => value.asEditable)
      )
    def plainTextMessage
        : Option[zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly]
    def customPayload: Option[zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly]
    def ssmlMessage: Option[zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly]
    def imageResponseCard
        : Option[zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly]
    def getPlainTextMessage: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly
    ] = AwsError.unwrapOptionField("plainTextMessage", plainTextMessage)
    def getCustomPayload
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly] =
      AwsError.unwrapOptionField("customPayload", customPayload)
    def getSsmlMessage
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly] =
      AwsError.unwrapOptionField("ssmlMessage", ssmlMessage)
    def getImageResponseCard: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly
    ] = AwsError.unwrapOptionField("imageResponseCard", imageResponseCard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Message
  ) extends zio.aws.lexmodelsv2.model.Message.ReadOnly {
    override val plainTextMessage
        : Option[zio.aws.lexmodelsv2.model.PlainTextMessage.ReadOnly] = scala
      .Option(impl.plainTextMessage())
      .map(value => zio.aws.lexmodelsv2.model.PlainTextMessage.wrap(value))
    override val customPayload
        : Option[zio.aws.lexmodelsv2.model.CustomPayload.ReadOnly] = scala
      .Option(impl.customPayload())
      .map(value => zio.aws.lexmodelsv2.model.CustomPayload.wrap(value))
    override val ssmlMessage
        : Option[zio.aws.lexmodelsv2.model.SSMLMessage.ReadOnly] = scala
      .Option(impl.ssmlMessage())
      .map(value => zio.aws.lexmodelsv2.model.SSMLMessage.wrap(value))
    override val imageResponseCard
        : Option[zio.aws.lexmodelsv2.model.ImageResponseCard.ReadOnly] = scala
      .Option(impl.imageResponseCard())
      .map(value => zio.aws.lexmodelsv2.model.ImageResponseCard.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.Message
  ): zio.aws.lexmodelsv2.model.Message.ReadOnly = new Wrapper(impl)
}
