package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResponseSpecification(
    messageGroups: Iterable[zio.aws.lexmodelsv2.model.MessageGroup],
    allowInterrupt: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ResponseSpecification = {
    import ResponseSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ResponseSpecification
      .builder()
      .messageGroups(messageGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        allowInterrupt.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.allowInterrupt)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(buildAwsValue())
}
object ResponseSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ResponseSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ResponseSpecification =
      zio.aws.lexmodelsv2.model.ResponseSpecification(
        messageGroups.map { item =>
          item.asEditable
        },
        allowInterrupt.map(value => value)
      )
    def messageGroups: List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly]
    def allowInterrupt: Option[BoxedBoolean]
    def getMessageGroups: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly
    ]] = ZIO.succeed(messageGroups)
    def getAllowInterrupt: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("allowInterrupt", allowInterrupt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ResponseSpecification
  ) extends zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly {
    override val messageGroups
        : List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly] = impl
      .messageGroups()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.MessageGroup.wrap(item)
      }
      .toList
    override val allowInterrupt: Option[BoxedBoolean] = scala
      .Option(impl.allowInterrupt())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BoxedBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ResponseSpecification
  ): zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly = new Wrapper(
    impl
  )
}
