package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StartImportResponse(
    importId: Option[Id] = None,
    resourceSpecification: Option[
      zio.aws.lexmodelsv2.model.ImportResourceSpecification
    ] = None,
    mergeStrategy: Option[zio.aws.lexmodelsv2.model.MergeStrategy] = None,
    importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus] = None,
    creationDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse = {
    import StartImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse
      .builder()
      .optionallyWith(
        importId.map(value => Id.unwrap(value): java.lang.String)
      )(_.importId)
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(mergeStrategy.map(value => value.unwrap))(_.mergeStrategy)
      .optionallyWith(importStatus.map(value => value.unwrap))(_.importStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.StartImportResponse.wrap(buildAwsValue())
}
object StartImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.StartImportResponse =
      zio.aws.lexmodelsv2.model.StartImportResponse(
        importId.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        mergeStrategy.map(value => value),
        importStatus.map(value => value),
        creationDateTime.map(value => value)
      )
    def importId: Option[Id]
    def resourceSpecification
        : Option[zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly]
    def mergeStrategy: Option[zio.aws.lexmodelsv2.model.MergeStrategy]
    def importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus]
    def creationDateTime: Option[Timestamp]
    def getImportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("importId", importId)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getMergeStrategy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.MergeStrategy] =
      AwsError.unwrapOptionField("mergeStrategy", mergeStrategy)
    def getImportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportStatus] =
      AwsError.unwrapOptionField("importStatus", importStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse
  ) extends zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly {
    override val importId: Option[Id] = scala
      .Option(impl.importId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val resourceSpecification: Option[
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ] = scala
      .Option(impl.resourceSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.ImportResourceSpecification.wrap(value)
      )
    override val mergeStrategy
        : Option[zio.aws.lexmodelsv2.model.MergeStrategy] = scala
      .Option(impl.mergeStrategy())
      .map(value => zio.aws.lexmodelsv2.model.MergeStrategy.wrap(value))
    override val importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus] =
      scala
        .Option(impl.importStatus())
        .map(value => zio.aws.lexmodelsv2.model.ImportStatus.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse
  ): zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly = new Wrapper(impl)
}
