package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait TimeDimension {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension
}
object TimeDimension {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension
  ): zio.aws.lexmodelsv2.model.TimeDimension = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension.HOURS =>
      val r = Hours
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension.DAYS =>
      val r = Days
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension.WEEKS =>
      val r = Weeks
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.TimeDimension {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension =
      software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension.UNKNOWN_TO_SDK_VERSION
  }
  case object Hours extends zio.aws.lexmodelsv2.model.TimeDimension {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension =
      software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension.HOURS
  }
  case object Days extends zio.aws.lexmodelsv2.model.TimeDimension {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension =
      software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension.DAYS
  }
  case object Weeks extends zio.aws.lexmodelsv2.model.TimeDimension {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension =
      software.amazon.awssdk.services.lexmodelsv2.model.TimeDimension.WEEKS
  }
}
