package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  BotAliasId,
  Timestamp,
  Description,
  BotVersion,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateBotAliasResponse(
    botAliasId: Option[BotAliasId] = None,
    botAliasName: Option[Name] = None,
    description: Option[Description] = None,
    botVersion: Option[BotVersion] = None,
    botAliasLocaleSettings: Option[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings]
    ] = None,
    conversationLogSettings: Option[
      zio.aws.lexmodelsv2.model.ConversationLogSettings
    ] = None,
    sentimentAnalysisSettings: Option[
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings
    ] = None,
    botAliasStatus: Option[zio.aws.lexmodelsv2.model.BotAliasStatus] = None,
    botId: Option[Id] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse = {
    import UpdateBotAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botAliasName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botAliasName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        botAliasLocaleSettings.map(value =>
          value
            .map({ case (key, value) =>
              (LocaleId.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.botAliasLocaleSettings)
      .optionallyWith(
        conversationLogSettings.map(value => value.buildAwsValue())
      )(_.conversationLogSettings)
      .optionallyWith(
        sentimentAnalysisSettings.map(value => value.buildAwsValue())
      )(_.sentimentAnalysisSettings)
      .optionallyWith(botAliasStatus.map(value => value.unwrap))(
        _.botAliasStatus
      )
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.wrap(buildAwsValue())
}
object UpdateBotAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateBotAliasResponse =
      zio.aws.lexmodelsv2.model.UpdateBotAliasResponse(
        botAliasId.map(value => value),
        botAliasName.map(value => value),
        description.map(value => value),
        botVersion.map(value => value),
        botAliasLocaleSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conversationLogSettings.map(value => value.asEditable),
        sentimentAnalysisSettings.map(value => value.asEditable),
        botAliasStatus.map(value => value),
        botId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def botAliasId: Option[BotAliasId]
    def botAliasName: Option[Name]
    def description: Option[Description]
    def botVersion: Option[BotVersion]
    def botAliasLocaleSettings: Option[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ]
    def conversationLogSettings
        : Option[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly]
    def sentimentAnalysisSettings
        : Option[zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly]
    def botAliasStatus: Option[zio.aws.lexmodelsv2.model.BotAliasStatus]
    def botId: Option[Id]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotAliasName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botAliasName", botAliasName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotAliasLocaleSettings: ZIO[Any, AwsError, Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "botAliasLocaleSettings",
      botAliasLocaleSettings
    )
    def getConversationLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLogSettings",
      conversationLogSettings
    )
    def getSentimentAnalysisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sentimentAnalysisSettings",
      sentimentAnalysisSettings
    )
    def getBotAliasStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotAliasStatus] =
      AwsError.unwrapOptionField("botAliasStatus", botAliasStatus)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.ReadOnly {
    override val botAliasId: Option[BotAliasId] = scala
      .Option(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botAliasName: Option[Name] = scala
      .Option(impl.botAliasName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val botAliasLocaleSettings: Option[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ] = scala
      .Option(impl.botAliasLocaleSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.LocaleId(
              key
            ) -> zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.wrap(value)
          })
          .toMap
      )
    override val conversationLogSettings
        : Option[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly] =
      scala
        .Option(impl.conversationLogSettings())
        .map(value =>
          zio.aws.lexmodelsv2.model.ConversationLogSettings.wrap(value)
        )
    override val sentimentAnalysisSettings
        : Option[zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly] =
      scala
        .Option(impl.sentimentAnalysisSettings())
        .map(value =>
          zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.wrap(value)
        )
    override val botAliasStatus
        : Option[zio.aws.lexmodelsv2.model.BotAliasStatus] = scala
      .Option(impl.botAliasStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotAliasStatus.wrap(value))
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse
  ): zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
