package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  RevisionId,
  Policy,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateResourcePolicyRequest(
    resourceArn: AmazonResourceName,
    policy: Policy,
    expectedRevisionId: Option[RevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest = {
    import UpdateResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .optionallyWith(
        expectedRevisionId.map(value =>
          RevisionId.unwrap(value): java.lang.String
        )
      )(_.expectedRevisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UpdateResourcePolicyRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateResourcePolicyRequest.wrap(buildAwsValue())
}
object UpdateResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateResourcePolicyRequest =
      zio.aws.lexmodelsv2.model.UpdateResourcePolicyRequest(
        resourceArn,
        policy,
        expectedRevisionId.map(value => value)
      )
    def resourceArn: AmazonResourceName
    def policy: Policy
    def expectedRevisionId: Option[RevisionId]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
    def getExpectedRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("expectedRevisionId", expectedRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest
  ) extends zio.aws.lexmodelsv2.model.UpdateResourcePolicyRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.lexmodelsv2.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val policy: Policy =
      zio.aws.lexmodelsv2.model.primitives.Policy(impl.policy())
    override val expectedRevisionId: Option[RevisionId] = scala
      .Option(impl.expectedRevisionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest
  ): zio.aws.lexmodelsv2.model.UpdateResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
