package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  HitCount,
  Timestamp,
  BoxedBoolean,
  Utterance,
  MissedCount
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AggregatedUtterancesSummary(
    utterance: Optional[Utterance] = Optional.Absent,
    hitCount: Optional[HitCount] = Optional.Absent,
    missedCount: Optional[MissedCount] = Optional.Absent,
    utteranceFirstRecordedInAggregationDuration: Optional[Timestamp] =
      Optional.Absent,
    utteranceLastRecordedInAggregationDuration: Optional[Timestamp] =
      Optional.Absent,
    containsDataFromDeletedResources: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesSummary = {
    import AggregatedUtterancesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesSummary
      .builder()
      .optionallyWith(
        utterance.map(value => Utterance.unwrap(value): java.lang.String)
      )(_.utterance)
      .optionallyWith(hitCount.map(value => HitCount.unwrap(value): Integer))(
        _.hitCount
      )
      .optionallyWith(
        missedCount.map(value => MissedCount.unwrap(value): Integer)
      )(_.missedCount)
      .optionallyWith(
        utteranceFirstRecordedInAggregationDuration.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.utteranceFirstRecordedInAggregationDuration)
      .optionallyWith(
        utteranceLastRecordedInAggregationDuration.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.utteranceLastRecordedInAggregationDuration)
      .optionallyWith(
        containsDataFromDeletedResources.map(value => value: java.lang.Boolean)
      )(_.containsDataFromDeletedResources)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.wrap(buildAwsValue())
}
object AggregatedUtterancesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary =
      zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary(
        utterance.map(value => value),
        hitCount.map(value => value),
        missedCount.map(value => value),
        utteranceFirstRecordedInAggregationDuration.map(value => value),
        utteranceLastRecordedInAggregationDuration.map(value => value),
        containsDataFromDeletedResources.map(value => value)
      )
    def utterance: Optional[Utterance]
    def hitCount: Optional[HitCount]
    def missedCount: Optional[MissedCount]
    def utteranceFirstRecordedInAggregationDuration: Optional[Timestamp]
    def utteranceLastRecordedInAggregationDuration: Optional[Timestamp]
    def containsDataFromDeletedResources: Optional[BoxedBoolean]
    def getUtterance: ZIO[Any, AwsError, Utterance] =
      AwsError.unwrapOptionField("utterance", utterance)
    def getHitCount: ZIO[Any, AwsError, HitCount] =
      AwsError.unwrapOptionField("hitCount", hitCount)
    def getMissedCount: ZIO[Any, AwsError, MissedCount] =
      AwsError.unwrapOptionField("missedCount", missedCount)
    def getUtteranceFirstRecordedInAggregationDuration
        : ZIO[Any, AwsError, Timestamp] = AwsError.unwrapOptionField(
      "utteranceFirstRecordedInAggregationDuration",
      utteranceFirstRecordedInAggregationDuration
    )
    def getUtteranceLastRecordedInAggregationDuration
        : ZIO[Any, AwsError, Timestamp] = AwsError.unwrapOptionField(
      "utteranceLastRecordedInAggregationDuration",
      utteranceLastRecordedInAggregationDuration
    )
    def getContainsDataFromDeletedResources: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "containsDataFromDeletedResources",
        containsDataFromDeletedResources
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesSummary
  ) extends zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly {
    override val utterance: Optional[Utterance] = zio.aws.core.internal
      .optionalFromNullable(impl.utterance())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Utterance(value))
    override val hitCount: Optional[HitCount] = zio.aws.core.internal
      .optionalFromNullable(impl.hitCount())
      .map(value => zio.aws.lexmodelsv2.model.primitives.HitCount(value))
    override val missedCount: Optional[MissedCount] = zio.aws.core.internal
      .optionalFromNullable(impl.missedCount())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MissedCount(value))
    override val utteranceFirstRecordedInAggregationDuration
        : Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.utteranceFirstRecordedInAggregationDuration())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val utteranceLastRecordedInAggregationDuration
        : Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.utteranceLastRecordedInAggregationDuration())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val containsDataFromDeletedResources: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containsDataFromDeletedResources())
        .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesSummary
  ): zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly =
    new Wrapper(impl)
}
