package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.ImportExportFilePassword
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateExportRequest(
    resourceSpecification: zio.aws.lexmodelsv2.model.ExportResourceSpecification,
    fileFormat: zio.aws.lexmodelsv2.model.ImportExportFileFormat,
    filePassword: Optional[ImportExportFilePassword] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest = {
    import CreateExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest
      .builder()
      .resourceSpecification(resourceSpecification.buildAwsValue())
      .fileFormat(fileFormat.unwrap)
      .optionallyWith(
        filePassword.map(value =>
          ImportExportFilePassword.unwrap(value): java.lang.String
        )
      )(_.filePassword)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateExportRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateExportRequest.wrap(buildAwsValue())
}
object CreateExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateExportRequest =
      zio.aws.lexmodelsv2.model.CreateExportRequest(
        resourceSpecification.asEditable,
        fileFormat,
        filePassword.map(value => value)
      )
    def resourceSpecification
        : zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    def fileFormat: zio.aws.lexmodelsv2.model.ImportExportFileFormat
    def filePassword: Optional[ImportExportFilePassword]
    def getResourceSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] = ZIO.succeed(resourceSpecification)
    def getFileFormat
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      ZIO.succeed(fileFormat)
    def getFilePassword: ZIO[Any, AwsError, ImportExportFilePassword] =
      AwsError.unwrapOptionField("filePassword", filePassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest
  ) extends zio.aws.lexmodelsv2.model.CreateExportRequest.ReadOnly {
    override val resourceSpecification
        : zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.ExportResourceSpecification
        .wrap(impl.resourceSpecification())
    override val fileFormat: zio.aws.lexmodelsv2.model.ImportExportFileFormat =
      zio.aws.lexmodelsv2.model.ImportExportFileFormat.wrap(impl.fileFormat())
    override val filePassword: Optional[ImportExportFilePassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filePassword())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ImportExportFilePassword(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest
  ): zio.aws.lexmodelsv2.model.CreateExportRequest.ReadOnly = new Wrapper(impl)
}
