package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait Effect {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.Effect
}
object Effect {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.Effect
  ): zio.aws.lexmodelsv2.model.Effect = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.Effect.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.Effect.ALLOW =>
      val r = Allow
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.Effect.DENY =>
      val r = Deny
      r
  }
  case object unknownToSdkVersion extends zio.aws.lexmodelsv2.model.Effect {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.Effect =
      software.amazon.awssdk.services.lexmodelsv2.model.Effect.UNKNOWN_TO_SDK_VERSION
  }
  case object Allow extends zio.aws.lexmodelsv2.model.Effect {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.Effect =
      software.amazon.awssdk.services.lexmodelsv2.model.Effect.ALLOW
  }
  case object Deny extends zio.aws.lexmodelsv2.model.Effect {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.Effect =
      software.amazon.awssdk.services.lexmodelsv2.model.Effect.DENY
  }
}
