package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExternalSourceSetting(
    grammarSlotTypeSetting: Optional[
      zio.aws.lexmodelsv2.model.GrammarSlotTypeSetting
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ExternalSourceSetting = {
    import ExternalSourceSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ExternalSourceSetting
      .builder()
      .optionallyWith(
        grammarSlotTypeSetting.map(value => value.buildAwsValue())
      )(_.grammarSlotTypeSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.ExternalSourceSetting.wrap(buildAwsValue())
}
object ExternalSourceSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ExternalSourceSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ExternalSourceSetting =
      zio.aws.lexmodelsv2.model.ExternalSourceSetting(
        grammarSlotTypeSetting.map(value => value.asEditable)
      )
    def grammarSlotTypeSetting
        : Optional[zio.aws.lexmodelsv2.model.GrammarSlotTypeSetting.ReadOnly]
    def getGrammarSlotTypeSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.GrammarSlotTypeSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "grammarSlotTypeSetting",
      grammarSlotTypeSetting
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExternalSourceSetting
  ) extends zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly {
    override val grammarSlotTypeSetting
        : Optional[zio.aws.lexmodelsv2.model.GrammarSlotTypeSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grammarSlotTypeSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.GrammarSlotTypeSetting.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ExternalSourceSetting
  ): zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly = new Wrapper(
    impl
  )
}
