package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  BotAliasId,
  Timestamp,
  BotVersion,
  Id
}
import scala.jdk.CollectionConverters.*
final case class ListAggregatedUtterancesResponse(
    botId: Optional[Id] = Optional.Absent,
    botAliasId: Optional[BotAliasId] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    aggregationDuration: Optional[
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration
    ] = Optional.Absent,
    aggregationWindowStartTime: Optional[Timestamp] = Optional.Absent,
    aggregationWindowEndTime: Optional[Timestamp] = Optional.Absent,
    aggregationLastRefreshedDateTime: Optional[Timestamp] = Optional.Absent,
    aggregatedUtterancesSummaries: Optional[
      Iterable[zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse = {
    import ListAggregatedUtterancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(aggregationDuration.map(value => value.buildAwsValue()))(
        _.aggregationDuration
      )
      .optionallyWith(
        aggregationWindowStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.aggregationWindowStartTime)
      .optionallyWith(
        aggregationWindowEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.aggregationWindowEndTime)
      .optionallyWith(
        aggregationLastRefreshedDateTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.aggregationLastRefreshedDateTime)
      .optionallyWith(
        aggregatedUtterancesSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregatedUtterancesSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse
      .wrap(buildAwsValue())
}
object ListAggregatedUtterancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse =
      zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse(
        botId.map(value => value),
        botAliasId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        aggregationDuration.map(value => value.asEditable),
        aggregationWindowStartTime.map(value => value),
        aggregationWindowEndTime.map(value => value),
        aggregationLastRefreshedDateTime.map(value => value),
        aggregatedUtterancesSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Optional[Id]
    def botAliasId: Optional[BotAliasId]
    def botVersion: Optional[BotVersion]
    def localeId: Optional[LocaleId]
    def aggregationDuration: Optional[
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    ]
    def aggregationWindowStartTime: Optional[Timestamp]
    def aggregationWindowEndTime: Optional[Timestamp]
    def aggregationLastRefreshedDateTime: Optional[Timestamp]
    def aggregatedUtterancesSummaries: Optional[
      List[zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getAggregationDuration: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    ] = AwsError.unwrapOptionField("aggregationDuration", aggregationDuration)
    def getAggregationWindowStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "aggregationWindowStartTime",
        aggregationWindowStartTime
      )
    def getAggregationWindowEndTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("aggregationWindowEndTime", aggregationWindowEndTime)
    def getAggregationLastRefreshedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "aggregationLastRefreshedDateTime",
        aggregationLastRefreshedDateTime
      )
    def getAggregatedUtterancesSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregatedUtterancesSummaries",
      aggregatedUtterancesSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
  ) extends zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botAliasId: Optional[BotAliasId] = zio.aws.core.internal
      .optionalFromNullable(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val aggregationDuration: Optional[
      zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.aggregationDuration())
      .map(value =>
        zio.aws.lexmodelsv2.model.UtteranceAggregationDuration.wrap(value)
      )
    override val aggregationWindowStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationWindowStartTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val aggregationWindowEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationWindowEndTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val aggregationLastRefreshedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationLastRefreshedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val aggregatedUtterancesSummaries: Optional[
      List[zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.aggregatedUtterancesSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AggregatedUtterancesSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
  ): zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly =
    new Wrapper(impl)
}
