package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  BuiltInsMaxResults,
  LocaleId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListBuiltInIntentsRequest(
    localeId: LocaleId,
    sortBy: Optional[zio.aws.lexmodelsv2.model.BuiltInIntentSortBy] =
      Optional.Absent,
    maxResults: Optional[BuiltInsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest = {
    import ListBuiltInIntentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest
      .builder()
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => BuiltInsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBuiltInIntentsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBuiltInIntentsRequest.wrap(buildAwsValue())
}
object ListBuiltInIntentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBuiltInIntentsRequest =
      zio.aws.lexmodelsv2.model.ListBuiltInIntentsRequest(
        localeId,
        sortBy.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def localeId: LocaleId
    def sortBy: Optional[zio.aws.lexmodelsv2.model.BuiltInIntentSortBy.ReadOnly]
    def maxResults: Optional[BuiltInsMaxResults]
    def nextToken: Optional[NextToken]
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BuiltInIntentSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, BuiltInsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest
  ) extends zio.aws.lexmodelsv2.model.ListBuiltInIntentsRequest.ReadOnly {
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val sortBy
        : Optional[zio.aws.lexmodelsv2.model.BuiltInIntentSortBy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.lexmodelsv2.model.BuiltInIntentSortBy.wrap(value))
    override val maxResults: Optional[BuiltInsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.BuiltInsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest
  ): zio.aws.lexmodelsv2.model.ListBuiltInIntentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
