package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  SlotTypeSignature,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class SlotTypeSummary(
    slotTypeId: Optional[Id] = Optional.Absent,
    slotTypeName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    parentSlotTypeSignature: Optional[SlotTypeSignature] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    slotTypeCategory: Optional[zio.aws.lexmodelsv2.model.SlotTypeCategory] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary = {
    import SlotTypeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary
      .builder()
      .optionallyWith(
        slotTypeId.map(value => Id.unwrap(value): java.lang.String)
      )(_.slotTypeId)
      .optionallyWith(
        slotTypeName.map(value => Name.unwrap(value): java.lang.String)
      )(_.slotTypeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parentSlotTypeSignature.map(value =>
          SlotTypeSignature.unwrap(value): java.lang.String
        )
      )(_.parentSlotTypeSignature)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(slotTypeCategory.map(value => value.unwrap))(
        _.slotTypeCategory
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotTypeSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotTypeSummary.wrap(buildAwsValue())
}
object SlotTypeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotTypeSummary =
      zio.aws.lexmodelsv2.model.SlotTypeSummary(
        slotTypeId.map(value => value),
        slotTypeName.map(value => value),
        description.map(value => value),
        parentSlotTypeSignature.map(value => value),
        lastUpdatedDateTime.map(value => value),
        slotTypeCategory.map(value => value)
      )
    def slotTypeId: Optional[Id]
    def slotTypeName: Optional[Name]
    def description: Optional[Description]
    def parentSlotTypeSignature: Optional[SlotTypeSignature]
    def lastUpdatedDateTime: Optional[Timestamp]
    def slotTypeCategory: Optional[zio.aws.lexmodelsv2.model.SlotTypeCategory]
    def getSlotTypeId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("slotTypeId", slotTypeId)
    def getSlotTypeName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("slotTypeName", slotTypeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParentSlotTypeSignature: ZIO[Any, AwsError, SlotTypeSignature] =
      AwsError.unwrapOptionField(
        "parentSlotTypeSignature",
        parentSlotTypeSignature
      )
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getSlotTypeCategory
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SlotTypeCategory] =
      AwsError.unwrapOptionField("slotTypeCategory", slotTypeCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary
  ) extends zio.aws.lexmodelsv2.model.SlotTypeSummary.ReadOnly {
    override val slotTypeId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.slotTypeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val slotTypeName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.slotTypeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val parentSlotTypeSignature: Optional[SlotTypeSignature] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentSlotTypeSignature())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.SlotTypeSignature(value)
        )
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val slotTypeCategory
        : Optional[zio.aws.lexmodelsv2.model.SlotTypeCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotTypeCategory())
        .map(value => zio.aws.lexmodelsv2.model.SlotTypeCategory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary
  ): zio.aws.lexmodelsv2.model.SlotTypeSummary.ReadOnly = new Wrapper(impl)
}
