package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters.*
final case class StartImportResponse(
    importId: Optional[Id] = Optional.Absent,
    resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ImportResourceSpecification
    ] = Optional.Absent,
    mergeStrategy: Optional[zio.aws.lexmodelsv2.model.MergeStrategy] =
      Optional.Absent,
    importStatus: Optional[zio.aws.lexmodelsv2.model.ImportStatus] =
      Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse = {
    import StartImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse
      .builder()
      .optionallyWith(
        importId.map(value => Id.unwrap(value): java.lang.String)
      )(_.importId)
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(mergeStrategy.map(value => value.unwrap))(_.mergeStrategy)
      .optionallyWith(importStatus.map(value => value.unwrap))(_.importStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.StartImportResponse.wrap(buildAwsValue())
}
object StartImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.StartImportResponse =
      zio.aws.lexmodelsv2.model.StartImportResponse(
        importId.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        mergeStrategy.map(value => value),
        importStatus.map(value => value),
        creationDateTime.map(value => value)
      )
    def importId: Optional[Id]
    def resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ]
    def mergeStrategy: Optional[zio.aws.lexmodelsv2.model.MergeStrategy]
    def importStatus: Optional[zio.aws.lexmodelsv2.model.ImportStatus]
    def creationDateTime: Optional[Timestamp]
    def getImportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("importId", importId)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getMergeStrategy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.MergeStrategy] =
      AwsError.unwrapOptionField("mergeStrategy", mergeStrategy)
    def getImportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportStatus] =
      AwsError.unwrapOptionField("importStatus", importStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse
  ) extends zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly {
    override val importId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.importId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.ImportResourceSpecification.wrap(value)
      )
    override val mergeStrategy
        : Optional[zio.aws.lexmodelsv2.model.MergeStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergeStrategy())
        .map(value => zio.aws.lexmodelsv2.model.MergeStrategy.wrap(value))
    override val importStatus
        : Optional[zio.aws.lexmodelsv2.model.ImportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importStatus())
        .map(value => zio.aws.lexmodelsv2.model.ImportStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse
  ): zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly = new Wrapper(impl)
}
