package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait TranscriptFormat {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat
}
object TranscriptFormat {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat
  ): zio.aws.lexmodelsv2.model.TranscriptFormat = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat.LEX =>
      val r = Lex
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.TranscriptFormat {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat =
      software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object Lex extends zio.aws.lexmodelsv2.model.TranscriptFormat {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat =
      software.amazon.awssdk.services.lexmodelsv2.model.TranscriptFormat.LEX
  }
}
