package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.VoiceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VoiceSettings(
    voiceId: VoiceId,
    engine: Optional[zio.aws.lexmodelsv2.model.VoiceEngine] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.VoiceSettings = {
    import VoiceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.VoiceSettings
      .builder()
      .voiceId(VoiceId.unwrap(voiceId): java.lang.String)
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly =
    zio.aws.lexmodelsv2.model.VoiceSettings.wrap(buildAwsValue())
}
object VoiceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.VoiceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.VoiceSettings =
      zio.aws.lexmodelsv2.model
        .VoiceSettings(voiceId, engine.map(value => value))
    def voiceId: VoiceId
    def engine: Optional[zio.aws.lexmodelsv2.model.VoiceEngine]
    def getVoiceId: ZIO[Any, Nothing, VoiceId] = ZIO.succeed(voiceId)
    def getEngine: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.VoiceEngine] =
      AwsError.unwrapOptionField("engine", engine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.VoiceSettings
  ) extends zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly {
    override val voiceId: VoiceId =
      zio.aws.lexmodelsv2.model.primitives.VoiceId(impl.voiceId())
    override val engine: Optional[zio.aws.lexmodelsv2.model.VoiceEngine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engine())
        .map(value => zio.aws.lexmodelsv2.model.VoiceEngine.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.VoiceSettings
  ): zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly = new Wrapper(impl)
}
