package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WaitAndContinueSpecification(
    waitingResponse: zio.aws.lexmodelsv2.model.ResponseSpecification,
    continueResponse: zio.aws.lexmodelsv2.model.ResponseSpecification,
    stillWaitingResponse: Optional[
      zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification
    ] = Optional.Absent,
    active: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.WaitAndContinueSpecification = {
    import WaitAndContinueSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.WaitAndContinueSpecification
      .builder()
      .waitingResponse(waitingResponse.buildAwsValue())
      .continueResponse(continueResponse.buildAwsValue())
      .optionallyWith(stillWaitingResponse.map(value => value.buildAwsValue()))(
        _.stillWaitingResponse
      )
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.wrap(buildAwsValue())
}
object WaitAndContinueSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.WaitAndContinueSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.WaitAndContinueSpecification =
      zio.aws.lexmodelsv2.model.WaitAndContinueSpecification(
        waitingResponse.asEditable,
        continueResponse.asEditable,
        stillWaitingResponse.map(value => value.asEditable),
        active.map(value => value)
      )
    def waitingResponse
        : zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    def continueResponse
        : zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    def stillWaitingResponse: Optional[
      zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification.ReadOnly
    ]
    def active: Optional[BoxedBoolean]
    def getWaitingResponse: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = ZIO.succeed(waitingResponse)
    def getContinueResponse: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = ZIO.succeed(continueResponse)
    def getStillWaitingResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("stillWaitingResponse", stillWaitingResponse)
    def getActive: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("active", active)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.WaitAndContinueSpecification
  ) extends zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly {
    override val waitingResponse
        : zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.ResponseSpecification
        .wrap(impl.waitingResponse())
    override val continueResponse
        : zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.ResponseSpecification
        .wrap(impl.continueResponse())
    override val stillWaitingResponse: Optional[
      zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stillWaitingResponse())
      .map(value =>
        zio.aws.lexmodelsv2.model.StillWaitingResponseSpecification.wrap(value)
      )
    override val active: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.WaitAndContinueSpecification
  ): zio.aws.lexmodelsv2.model.WaitAndContinueSpecification.ReadOnly =
    new Wrapper(impl)
}
