package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AggregatedUtterancesFilter(
    name: zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterName,
    values: Iterable[FilterValue],
    operator: zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesFilter = {
    import AggregatedUtterancesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.wrap(buildAwsValue())
}
object AggregatedUtterancesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter =
      zio.aws.lexmodelsv2.model
        .AggregatedUtterancesFilter(name, values, operator)
    def name: zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterName
    def values: List[FilterValue]
    def operator: zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterOperator
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterName
    ] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
    def getOperator: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterOperator
    ] = ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesFilter
  ) extends zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly {
    override val name
        : zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterName =
      zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
    override val operator
        : zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterOperator =
      zio.aws.lexmodelsv2.model.AggregatedUtterancesFilterOperator
        .wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesFilter
  ): zio.aws.lexmodelsv2.model.AggregatedUtterancesFilter.ReadOnly =
    new Wrapper(impl)
}
