package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextIndex,
  MaxResults,
  BotVersion,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchAssociatedTranscriptsRequest(
    botId: Id,
    botVersion: BotVersion,
    localeId: LocaleId,
    botRecommendationId: Id,
    searchOrder: Optional[zio.aws.lexmodelsv2.model.SearchOrder] =
      Optional.Absent,
    filters: Iterable[zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter],
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextIndex: Optional[NextIndex] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest = {
    import SearchAssociatedTranscriptsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .botRecommendationId(Id.unwrap(botRecommendationId): java.lang.String)
      .optionallyWith(searchOrder.map(value => value.unwrap))(_.searchOrder)
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextIndex.map(value => NextIndex.unwrap(value): Integer))(
        _.nextIndex
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsRequest
      .wrap(buildAwsValue())
}
object SearchAssociatedTranscriptsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsRequest =
      zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsRequest(
        botId,
        botVersion,
        localeId,
        botRecommendationId,
        searchOrder.map(value => value),
        filters.map { item =>
          item.asEditable
        },
        maxResults.map(value => value),
        nextIndex.map(value => value)
      )
    def botId: Id
    def botVersion: BotVersion
    def localeId: LocaleId
    def botRecommendationId: Id
    def searchOrder: Optional[zio.aws.lexmodelsv2.model.SearchOrder]
    def filters
        : List[zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter.ReadOnly]
    def maxResults: Optional[MaxResults]
    def nextIndex: Optional[NextIndex]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getBotRecommendationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(botRecommendationId)
    def getSearchOrder
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SearchOrder] =
      AwsError.unwrapOptionField("searchOrder", searchOrder)
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter.ReadOnly
    ]] = ZIO.succeed(filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextIndex: ZIO[Any, AwsError, NextIndex] =
      AwsError.unwrapOptionField("nextIndex", nextIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest
  ) extends zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val botRecommendationId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botRecommendationId())
    override val searchOrder: Optional[zio.aws.lexmodelsv2.model.SearchOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchOrder())
        .map(value => zio.aws.lexmodelsv2.model.SearchOrder.wrap(value))
    override val filters
        : List[zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter.ReadOnly] =
      impl
        .filters()
        .asScala
        .map { item =>
          zio.aws.lexmodelsv2.model.AssociatedTranscriptFilter.wrap(item)
        }
        .toList
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextIndex: Optional[NextIndex] = zio.aws.core.internal
      .optionalFromNullable(impl.nextIndex())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextIndex(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest
  ): zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsRequest.ReadOnly =
    new Wrapper(impl)
}
