package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TranscriptSourceSetting(
    s3BucketTranscriptSource: Optional[
      zio.aws.lexmodelsv2.model.S3BucketTranscriptSource
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.TranscriptSourceSetting = {
    import TranscriptSourceSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.TranscriptSourceSetting
      .builder()
      .optionallyWith(
        s3BucketTranscriptSource.map(value => value.buildAwsValue())
      )(_.s3BucketTranscriptSource)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.TranscriptSourceSetting.wrap(buildAwsValue())
}
object TranscriptSourceSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.TranscriptSourceSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.TranscriptSourceSetting =
      zio.aws.lexmodelsv2.model.TranscriptSourceSetting(
        s3BucketTranscriptSource.map(value => value.asEditable)
      )
    def s3BucketTranscriptSource
        : Optional[zio.aws.lexmodelsv2.model.S3BucketTranscriptSource.ReadOnly]
    def getS3BucketTranscriptSource: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.S3BucketTranscriptSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3BucketTranscriptSource",
      s3BucketTranscriptSource
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TranscriptSourceSetting
  ) extends zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly {
    override val s3BucketTranscriptSource: Optional[
      zio.aws.lexmodelsv2.model.S3BucketTranscriptSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketTranscriptSource())
      .map(value =>
        zio.aws.lexmodelsv2.model.S3BucketTranscriptSource.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.TranscriptSourceSetting
  ): zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly = new Wrapper(
    impl
  )
}
