package zio.aws.lexmodelsv2
import zio.aws.lexmodelsv2.model.ListBotRecommendationsResponse.ReadOnly
import zio.aws.lexmodelsv2.model.{
  UpdateSlotTypeRequest,
  DeleteBotLocaleRequest,
  UpdateExportRequest,
  DeleteResourcePolicyStatementRequest,
  DescribeBotRecommendationRequest,
  CreateIntentRequest,
  CreateBotRequest,
  ListIntentsRequest,
  ListBotAliasesRequest,
  ListRecommendedIntentsRequest,
  DescribeBotRequest,
  SearchAssociatedTranscriptsRequest,
  DeleteBotAliasRequest,
  DescribeImportRequest,
  ListSlotTypesRequest,
  ListAggregatedUtterancesRequest,
  DeleteBotRequest,
  ListSlotsRequest,
  DeleteIntentRequest,
  ListBotRecommendationsRequest,
  DeleteExportRequest,
  ListImportsRequest,
  DeleteBotVersionRequest,
  CreateUploadUrlRequest,
  CreateSlotRequest,
  UpdateBotRecommendationRequest,
  UpdateResourcePolicyRequest,
  ListTagsForResourceRequest,
  CreateSlotTypeRequest,
  DescribeIntentRequest,
  DeleteCustomVocabularyRequest,
  ListBotsRequest,
  ListBuiltInIntentsRequest,
  ListExportsRequest,
  DeleteUtterancesRequest,
  ListBotLocalesRequest,
  ListBotVersionsRequest,
  CreateResourcePolicyRequest,
  UpdateIntentRequest,
  DescribeBotVersionRequest,
  UpdateSlotRequest,
  CreateExportRequest,
  CreateBotLocaleRequest,
  UpdateBotAliasRequest,
  DescribeBotAliasRequest,
  DescribeBotLocaleRequest,
  DescribeSlotRequest,
  ListBuiltInSlotTypesRequest,
  BuildBotLocaleRequest,
  DescribeSlotTypeRequest,
  StartBotRecommendationRequest,
  DeleteResourcePolicyRequest,
  UntagResourceRequest,
  UpdateBotRequest,
  CreateBotVersionRequest,
  DeleteImportRequest,
  DeleteSlotRequest,
  DescribeCustomVocabularyMetadataRequest,
  DeleteSlotTypeRequest,
  DescribeResourcePolicyRequest,
  CreateResourcePolicyStatementRequest,
  DescribeExportRequest,
  CreateBotAliasRequest,
  UpdateBotLocaleRequest,
  TagResourceRequest,
  StartImportRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient
import zio.{IO, ZEnvironment, URLayer}
object LexModelsV2Mock extends Mock[LexModelsV2] {
  object CreateResourcePolicyStatement
      extends Effect[
        CreateResourcePolicyStatementRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.ReadOnly
      ]
  object ListSlots
      extends Effect[
        ListSlotsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListSlotsResponse.ReadOnly
      ]
  object CreateBotVersion
      extends Effect[
        CreateBotVersionRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateBotVersionResponse.ReadOnly
      ]
  object ListBotAliases
      extends Effect[
        ListBotAliasesRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly
      ]
  object UpdateBot
      extends Effect[
        UpdateBotRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateBotResponse.ReadOnly
      ]
  object ListBotVersions
      extends Effect[
        ListBotVersionsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListBotVersionsResponse.ReadOnly
      ]
  object CreateBotLocale
      extends Effect[
        CreateBotLocaleRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.ReadOnly
      ]
  object ListIntents
      extends Effect[
        ListIntentsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly
      ]
  object CreateUploadUrl
      extends Effect[
        CreateUploadUrlRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly
      ]
  object DescribeIntent
      extends Effect[
        DescribeIntentRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeIntentResponse.ReadOnly
      ]
  object StartBotRecommendation
      extends Effect[
        StartBotRecommendationRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.StartBotRecommendationResponse.ReadOnly
      ]
  object DescribeSlot
      extends Effect[
        DescribeSlotRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeSlotResponse.ReadOnly
      ]
  object DeleteSlotType extends Effect[DeleteSlotTypeRequest, AwsError, Unit]
  object ListImports
      extends Effect[
        ListImportsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly
      ]
  object StartImport
      extends Effect[
        StartImportRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly
      ]
  object UpdateSlot
      extends Effect[
        UpdateSlotRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateSlotResponse.ReadOnly
      ]
  object UpdateSlotType
      extends Effect[
        UpdateSlotTypeRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.ReadOnly
      ]
  object UpdateExport
      extends Effect[
        UpdateExportRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly
      ]
  object DescribeBotLocale
      extends Effect[
        DescribeBotLocaleRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly
      ]
  object ListAggregatedUtterances
      extends Effect[
        ListAggregatedUtterancesRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly
      ]
  object SearchAssociatedTranscripts
      extends Effect[
        SearchAssociatedTranscriptsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.ReadOnly
      ]
  object DeleteSlot extends Effect[DeleteSlotRequest, AwsError, Unit]
  object DeleteResourcePolicyStatement
      extends Effect[
        DeleteResourcePolicyStatementRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementResponse.ReadOnly
      ]
  object UpdateBotLocale
      extends Effect[
        UpdateBotLocaleRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.ReadOnly
      ]
  object DescribeBotAlias
      extends Effect[
        DescribeBotAliasRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.ReadOnly
      ]
  object DescribeExport
      extends Effect[
        DescribeExportRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeExportResponse.ReadOnly
      ]
  object ListExports
      extends Effect[
        ListExportsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly
      ]
  object UpdateBotAlias
      extends Effect[
        UpdateBotAliasRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.ReadOnly
      ]
  object DescribeSlotType
      extends Effect[
        DescribeSlotTypeRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.ReadOnly
      ]
  object DeleteUtterances
      extends Effect[
        DeleteUtterancesRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteUtterancesResponse.ReadOnly
      ]
  object DescribeBotRecommendation
      extends Effect[
        DescribeBotRecommendationRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeBotRecommendationResponse.ReadOnly
      ]
  object UpdateIntent
      extends Effect[
        UpdateIntentRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateIntentResponse.ReadOnly
      ]
  object CreateBotAlias
      extends Effect[
        CreateBotAliasRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly
      ]
  object BuildBotLocale
      extends Effect[
        BuildBotLocaleRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.ReadOnly
      ]
  object ListBuiltInIntents
      extends Effect[
        ListBuiltInIntentsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly
      ]
  object UpdateBotRecommendation
      extends Effect[
        UpdateBotRecommendationRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly
      ]
  object DeleteBotAlias
      extends Effect[
        DeleteBotAliasRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly
      ]
  object DeleteBotLocale
      extends Effect[
        DeleteBotLocaleRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.ReadOnly
      ]
  object UpdateResourcePolicy
      extends Effect[
        UpdateResourcePolicyRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.ReadOnly
      ]
  object DeleteBotVersion
      extends Effect[
        DeleteBotVersionRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly
      ]
  object DeleteExport
      extends Effect[
        DeleteExportRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteExportResponse.ReadOnly
      ]
  object ListBotLocales
      extends Effect[
        ListBotLocalesRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.UntagResourceResponse.ReadOnly
      ]
  object CreateIntent
      extends Effect[
        CreateIntentRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateIntentResponse.ReadOnly
      ]
  object ListBots
      extends Effect[
        ListBotsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly
      ]
  object CreateSlotType
      extends Effect[
        CreateSlotTypeRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateSlotTypeResponse.ReadOnly
      ]
  object DescribeImport
      extends Effect[
        DescribeImportRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeImportResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object CreateBot
      extends Effect[
        CreateBotRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateBotResponse.ReadOnly
      ]
  object CreateSlot
      extends Effect[
        CreateSlotRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateSlotResponse.ReadOnly
      ]
  object DescribeBot
      extends Effect[
        DescribeBotRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly
      ]
  object DeleteIntent extends Effect[DeleteIntentRequest, AwsError, Unit]
  object ListRecommendedIntents
      extends Effect[
        ListRecommendedIntentsRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListBotRecommendations
      extends Effect[ListBotRecommendationsRequest, AwsError, ReadOnly]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.TagResourceResponse.ReadOnly
      ]
  object DescribeBotVersion
      extends Effect[
        DescribeBotVersionRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.ReadOnly
      ]
  object DescribeResourcePolicy
      extends Effect[
        DescribeResourcePolicyRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.ReadOnly
      ]
  object DeleteImport
      extends Effect[
        DeleteImportRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteImportResponse.ReadOnly
      ]
  object CreateExport
      extends Effect[
        CreateExportRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly
      ]
  object CreateResourcePolicy
      extends Effect[
        CreateResourcePolicyRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.CreateResourcePolicyResponse.ReadOnly
      ]
  object ListSlotTypes
      extends Effect[
        ListSlotTypesRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListSlotTypesResponse.ReadOnly
      ]
  object ListBuiltInSlotTypes
      extends Effect[
        ListBuiltInSlotTypesRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.ReadOnly
      ]
  object DeleteBot
      extends Effect[
        DeleteBotRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteBotResponse.ReadOnly
      ]
  object DeleteCustomVocabulary
      extends Effect[
        DeleteCustomVocabularyRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.ReadOnly
      ]
  object DescribeCustomVocabularyMetadata
      extends Effect[
        DescribeCustomVocabularyMetadataRequest,
        AwsError,
        zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LexModelsV2] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, LexModelsV2] { rts =>
        zio.ZIO.succeed {
          new LexModelsV2 {
            val api: LexModelsV2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): LexModelsV2 = this
            def createResourcePolicyStatement(
                request: CreateResourcePolicyStatementRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.ReadOnly
            ] = proxy(CreateResourcePolicyStatement, request)
            def listSlots(request: ListSlotsRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListSlotsResponse.ReadOnly
            ] = proxy(ListSlots, request)
            def createBotVersion(request: CreateBotVersionRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateBotVersionResponse.ReadOnly
            ] = proxy(CreateBotVersion, request)
            def listBotAliases(request: ListBotAliasesRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly
            ] = proxy(ListBotAliases, request)
            def updateBot(request: UpdateBotRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateBotResponse.ReadOnly
            ] = proxy(UpdateBot, request)
            def listBotVersions(request: ListBotVersionsRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListBotVersionsResponse.ReadOnly
            ] = proxy(ListBotVersions, request)
            def createBotLocale(request: CreateBotLocaleRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateBotLocaleResponse.ReadOnly
            ] = proxy(CreateBotLocale, request)
            def listIntents(request: ListIntentsRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListIntentsResponse.ReadOnly
            ] = proxy(ListIntents, request)
            def createUploadUrl(request: CreateUploadUrlRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateUploadUrlResponse.ReadOnly
            ] = proxy(CreateUploadUrl, request)
            def describeIntent(request: DescribeIntentRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeIntentResponse.ReadOnly
            ] = proxy(DescribeIntent, request)
            def startBotRecommendation(
                request: StartBotRecommendationRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.StartBotRecommendationResponse.ReadOnly
            ] = proxy(StartBotRecommendation, request)
            def describeSlot(request: DescribeSlotRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeSlotResponse.ReadOnly
            ] = proxy(DescribeSlot, request)
            def deleteSlotType(
                request: DeleteSlotTypeRequest
            ): IO[AwsError, Unit] = proxy(DeleteSlotType, request)
            def listImports(request: ListImportsRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListImportsResponse.ReadOnly
            ] = proxy(ListImports, request)
            def startImport(request: StartImportRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.StartImportResponse.ReadOnly
            ] = proxy(StartImport, request)
            def updateSlot(request: UpdateSlotRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateSlotResponse.ReadOnly
            ] = proxy(UpdateSlot, request)
            def updateSlotType(request: UpdateSlotTypeRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateSlotTypeResponse.ReadOnly
            ] = proxy(UpdateSlotType, request)
            def updateExport(request: UpdateExportRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly
            ] = proxy(UpdateExport, request)
            def describeBotLocale(request: DescribeBotLocaleRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly
            ] = proxy(DescribeBotLocale, request)
            def listAggregatedUtterances(
                request: ListAggregatedUtterancesRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListAggregatedUtterancesResponse.ReadOnly
            ] = proxy(ListAggregatedUtterances, request)
            def searchAssociatedTranscripts(
                request: SearchAssociatedTranscriptsRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.ReadOnly
            ] = proxy(SearchAssociatedTranscripts, request)
            def deleteSlot(request: DeleteSlotRequest): IO[AwsError, Unit] =
              proxy(DeleteSlot, request)
            def deleteResourcePolicyStatement(
                request: DeleteResourcePolicyStatementRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteResourcePolicyStatementResponse.ReadOnly
            ] = proxy(DeleteResourcePolicyStatement, request)
            def updateBotLocale(request: UpdateBotLocaleRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateBotLocaleResponse.ReadOnly
            ] = proxy(UpdateBotLocale, request)
            def describeBotAlias(request: DescribeBotAliasRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeBotAliasResponse.ReadOnly
            ] = proxy(DescribeBotAlias, request)
            def describeExport(request: DescribeExportRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeExportResponse.ReadOnly
            ] = proxy(DescribeExport, request)
            def listExports(request: ListExportsRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListExportsResponse.ReadOnly
            ] = proxy(ListExports, request)
            def updateBotAlias(request: UpdateBotAliasRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateBotAliasResponse.ReadOnly
            ] = proxy(UpdateBotAlias, request)
            def describeSlotType(request: DescribeSlotTypeRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.ReadOnly
            ] = proxy(DescribeSlotType, request)
            def deleteUtterances(request: DeleteUtterancesRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteUtterancesResponse.ReadOnly
            ] = proxy(DeleteUtterances, request)
            def describeBotRecommendation(
                request: DescribeBotRecommendationRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeBotRecommendationResponse.ReadOnly
            ] = proxy(DescribeBotRecommendation, request)
            def updateIntent(request: UpdateIntentRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateIntentResponse.ReadOnly
            ] = proxy(UpdateIntent, request)
            def createBotAlias(request: CreateBotAliasRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly
            ] = proxy(CreateBotAlias, request)
            def buildBotLocale(request: BuildBotLocaleRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.BuildBotLocaleResponse.ReadOnly
            ] = proxy(BuildBotLocale, request)
            def listBuiltInIntents(request: ListBuiltInIntentsRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListBuiltInIntentsResponse.ReadOnly
            ] = proxy(ListBuiltInIntents, request)
            def updateBotRecommendation(
                request: UpdateBotRecommendationRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly
            ] = proxy(UpdateBotRecommendation, request)
            def deleteBotAlias(request: DeleteBotAliasRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly
            ] = proxy(DeleteBotAlias, request)
            def deleteBotLocale(request: DeleteBotLocaleRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteBotLocaleResponse.ReadOnly
            ] = proxy(DeleteBotLocale, request)
            def updateResourcePolicy(request: UpdateResourcePolicyRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UpdateResourcePolicyResponse.ReadOnly
            ] = proxy(UpdateResourcePolicy, request)
            def deleteBotVersion(request: DeleteBotVersionRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly
            ] = proxy(DeleteBotVersion, request)
            def deleteExport(request: DeleteExportRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteExportResponse.ReadOnly
            ] = proxy(DeleteExport, request)
            def listBotLocales(request: ListBotLocalesRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListBotLocalesResponse.ReadOnly
            ] = proxy(ListBotLocales, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createIntent(request: CreateIntentRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateIntentResponse.ReadOnly
            ] = proxy(CreateIntent, request)
            def listBots(request: ListBotsRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly
            ] = proxy(ListBots, request)
            def createSlotType(request: CreateSlotTypeRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateSlotTypeResponse.ReadOnly
            ] = proxy(CreateSlotType, request)
            def describeImport(request: DescribeImportRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeImportResponse.ReadOnly
            ] = proxy(DescribeImport, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def createBot(request: CreateBotRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateBotResponse.ReadOnly
            ] = proxy(CreateBot, request)
            def createSlot(request: CreateSlotRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateSlotResponse.ReadOnly
            ] = proxy(CreateSlot, request)
            def describeBot(request: DescribeBotRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly
            ] = proxy(DescribeBot, request)
            def deleteIntent(request: DeleteIntentRequest): IO[AwsError, Unit] =
              proxy(DeleteIntent, request)
            def listRecommendedIntents(
                request: ListRecommendedIntentsRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListRecommendedIntentsResponse.ReadOnly
            ] = proxy(ListRecommendedIntents, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listBotRecommendations(
                request: ListBotRecommendationsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListBotRecommendations, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def describeBotVersion(request: DescribeBotVersionRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeBotVersionResponse.ReadOnly
            ] = proxy(DescribeBotVersion, request)
            def describeResourcePolicy(
                request: DescribeResourcePolicyRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeResourcePolicyResponse.ReadOnly
            ] = proxy(DescribeResourcePolicy, request)
            def deleteImport(request: DeleteImportRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteImportResponse.ReadOnly
            ] = proxy(DeleteImport, request)
            def createExport(request: CreateExportRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateExportResponse.ReadOnly
            ] = proxy(CreateExport, request)
            def createResourcePolicy(request: CreateResourcePolicyRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.CreateResourcePolicyResponse.ReadOnly
            ] = proxy(CreateResourcePolicy, request)
            def listSlotTypes(request: ListSlotTypesRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListSlotTypesResponse.ReadOnly
            ] = proxy(ListSlotTypes, request)
            def listBuiltInSlotTypes(request: ListBuiltInSlotTypesRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.ReadOnly
            ] = proxy(ListBuiltInSlotTypes, request)
            def deleteBot(request: DeleteBotRequest): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteBotResponse.ReadOnly
            ] = proxy(DeleteBot, request)
            def deleteCustomVocabulary(
                request: DeleteCustomVocabularyRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.ReadOnly
            ] = proxy(DeleteCustomVocabulary, request)
            def describeCustomVocabularyMetadata(
                request: DescribeCustomVocabularyMetadataRequest
            ): IO[
              AwsError,
              zio.aws.lexmodelsv2.model.DescribeCustomVocabularyMetadataResponse.ReadOnly
            ] = proxy(DescribeCustomVocabularyMetadata, request)
          }
        }
      }
    }
  }
}
