package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, DraftBotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteCustomVocabularyResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[DraftBotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    customVocabularyStatus: Optional[
      zio.aws.lexmodelsv2.model.CustomVocabularyStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse = {
    import DeleteCustomVocabularyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(customVocabularyStatus.map(value => value.unwrap))(
        _.customVocabularyStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse
      .wrap(buildAwsValue())
}
object DeleteCustomVocabularyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse =
      zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        customVocabularyStatus.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[DraftBotVersion]
    def localeId: Optional[LocaleId]
    def customVocabularyStatus
        : Optional[zio.aws.lexmodelsv2.model.CustomVocabularyStatus]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getCustomVocabularyStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.CustomVocabularyStatus] =
      AwsError.unwrapOptionField(
        "customVocabularyStatus",
        customVocabularyStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[DraftBotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val customVocabularyStatus
        : Optional[zio.aws.lexmodelsv2.model.CustomVocabularyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customVocabularyStatus())
        .map(value =>
          zio.aws.lexmodelsv2.model.CustomVocabularyStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteCustomVocabularyResponse
  ): zio.aws.lexmodelsv2.model.DeleteCustomVocabularyResponse.ReadOnly =
    new Wrapper(impl)
}
