package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteExportRequest(exportId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest = {
    import DeleteExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest
      .builder()
      .exportId(Id.unwrap(exportId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteExportRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteExportRequest.wrap(buildAwsValue())
}
object DeleteExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteExportRequest =
      zio.aws.lexmodelsv2.model.DeleteExportRequest(exportId)
    def exportId: Id
    def getExportId: ZIO[Any, Nothing, Id] = ZIO.succeed(exportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteExportRequest.ReadOnly {
    override val exportId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.exportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest
  ): zio.aws.lexmodelsv2.model.DeleteExportRequest.ReadOnly = new Wrapper(impl)
}
