package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeImportRequest(importId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest = {
    import DescribeImportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest
      .builder()
      .importId(Id.unwrap(importId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeImportRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeImportRequest.wrap(buildAwsValue())
}
object DescribeImportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeImportRequest =
      zio.aws.lexmodelsv2.model.DescribeImportRequest(importId)
    def importId: Id
    def getImportId: ZIO[Any, Nothing, Id] = ZIO.succeed(importId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest
  ) extends zio.aws.lexmodelsv2.model.DescribeImportRequest.ReadOnly {
    override val importId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.importId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest
  ): zio.aws.lexmodelsv2.model.DescribeImportRequest.ReadOnly = new Wrapper(
    impl
  )
}
