package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait IntentFilterName {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.IntentFilterName
}
object IntentFilterName {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.IntentFilterName
  ): zio.aws.lexmodelsv2.model.IntentFilterName = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.IntentFilterName.INTENT_NAME =>
      val r = IntentName
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.IntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object IntentName extends zio.aws.lexmodelsv2.model.IntentFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.IntentFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.IntentFilterName.INTENT_NAME
  }
}
