package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CompositeSlotTypeSetting(
    subSlots: Optional[
      Iterable[zio.aws.lexmodelsv2.model.SubSlotTypeComposition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CompositeSlotTypeSetting = {
    import CompositeSlotTypeSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CompositeSlotTypeSetting
      .builder()
      .optionallyWith(
        subSlots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subSlots)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CompositeSlotTypeSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.CompositeSlotTypeSetting.wrap(buildAwsValue())
}
object CompositeSlotTypeSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CompositeSlotTypeSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CompositeSlotTypeSetting =
      zio.aws.lexmodelsv2.model.CompositeSlotTypeSetting(
        subSlots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subSlots: Optional[
      List[zio.aws.lexmodelsv2.model.SubSlotTypeComposition.ReadOnly]
    ]
    def getSubSlots: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SubSlotTypeComposition.ReadOnly
    ]] = AwsError.unwrapOptionField("subSlots", subSlots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CompositeSlotTypeSetting
  ) extends zio.aws.lexmodelsv2.model.CompositeSlotTypeSetting.ReadOnly {
    override val subSlots: Optional[
      List[zio.aws.lexmodelsv2.model.SubSlotTypeComposition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subSlots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.SubSlotTypeComposition.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CompositeSlotTypeSetting
  ): zio.aws.lexmodelsv2.model.CompositeSlotTypeSetting.ReadOnly = new Wrapper(
    impl
  )
}
