package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IntentConfirmationSetting(
    promptSpecification: zio.aws.lexmodelsv2.model.PromptSpecification,
    declinationResponse: Optional[
      zio.aws.lexmodelsv2.model.ResponseSpecification
    ] = Optional.Absent,
    active: Optional[BoxedBoolean] = Optional.Absent,
    confirmationResponse: Optional[
      zio.aws.lexmodelsv2.model.ResponseSpecification
    ] = Optional.Absent,
    confirmationNextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] =
      Optional.Absent,
    confirmationConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification
    ] = Optional.Absent,
    declinationNextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] =
      Optional.Absent,
    declinationConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification
    ] = Optional.Absent,
    failureResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    failureNextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] =
      Optional.Absent,
    failureConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification
    ] = Optional.Absent,
    codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting
    ] = Optional.Absent,
    elicitationCodeHook: Optional[
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting = {
    import IntentConfirmationSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting
      .builder()
      .promptSpecification(promptSpecification.buildAwsValue())
      .optionallyWith(declinationResponse.map(value => value.buildAwsValue()))(
        _.declinationResponse
      )
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .optionallyWith(confirmationResponse.map(value => value.buildAwsValue()))(
        _.confirmationResponse
      )
      .optionallyWith(confirmationNextStep.map(value => value.buildAwsValue()))(
        _.confirmationNextStep
      )
      .optionallyWith(
        confirmationConditional.map(value => value.buildAwsValue())
      )(_.confirmationConditional)
      .optionallyWith(declinationNextStep.map(value => value.buildAwsValue()))(
        _.declinationNextStep
      )
      .optionallyWith(
        declinationConditional.map(value => value.buildAwsValue())
      )(_.declinationConditional)
      .optionallyWith(failureResponse.map(value => value.buildAwsValue()))(
        _.failureResponse
      )
      .optionallyWith(failureNextStep.map(value => value.buildAwsValue()))(
        _.failureNextStep
      )
      .optionallyWith(failureConditional.map(value => value.buildAwsValue()))(
        _.failureConditional
      )
      .optionallyWith(codeHook.map(value => value.buildAwsValue()))(_.codeHook)
      .optionallyWith(elicitationCodeHook.map(value => value.buildAwsValue()))(
        _.elicitationCodeHook
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentConfirmationSetting.wrap(buildAwsValue())
}
object IntentConfirmationSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentConfirmationSetting =
      zio.aws.lexmodelsv2.model.IntentConfirmationSetting(
        promptSpecification.asEditable,
        declinationResponse.map(value => value.asEditable),
        active.map(value => value),
        confirmationResponse.map(value => value.asEditable),
        confirmationNextStep.map(value => value.asEditable),
        confirmationConditional.map(value => value.asEditable),
        declinationNextStep.map(value => value.asEditable),
        declinationConditional.map(value => value.asEditable),
        failureResponse.map(value => value.asEditable),
        failureNextStep.map(value => value.asEditable),
        failureConditional.map(value => value.asEditable),
        codeHook.map(value => value.asEditable),
        elicitationCodeHook.map(value => value.asEditable)
      )
    def promptSpecification
        : zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    def declinationResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def active: Optional[BoxedBoolean]
    def confirmationResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def confirmationNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def confirmationConditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def declinationNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def declinationConditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def failureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def failureNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def failureConditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ]
    def elicitationCodeHook: Optional[
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly
    ]
    def getPromptSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    ] = ZIO.succeed(promptSpecification)
    def getDeclinationResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("declinationResponse", declinationResponse)
    def getActive: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("active", active)
    def getConfirmationResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("confirmationResponse", confirmationResponse)
    def getConfirmationNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("confirmationNextStep", confirmationNextStep)
    def getConfirmationConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "confirmationConditional",
      confirmationConditional
    )
    def getDeclinationNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("declinationNextStep", declinationNextStep)
    def getDeclinationConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "declinationConditional",
      declinationConditional
    )
    def getFailureResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("failureResponse", failureResponse)
    def getFailureNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("failureNextStep", failureNextStep)
    def getFailureConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("failureConditional", failureConditional)
    def getCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ] = AwsError.unwrapOptionField("codeHook", codeHook)
    def getElicitationCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly
    ] = AwsError.unwrapOptionField("elicitationCodeHook", elicitationCodeHook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting
  ) extends zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly {
    override val promptSpecification
        : zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.PromptSpecification
        .wrap(impl.promptSpecification())
    override val declinationResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.declinationResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val active: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.active())
      .map(value => value: BoxedBoolean)
    override val confirmationResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.confirmationResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val confirmationNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.confirmationNextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val confirmationConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.confirmationConditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
    override val declinationNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.declinationNextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val declinationConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.declinationConditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
    override val failureResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val failureNextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureNextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val failureConditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failureConditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
    override val codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.codeHook())
      .map(value =>
        zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.wrap(value)
      )
    override val elicitationCodeHook: Optional[
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elicitationCodeHook())
      .map(value =>
        zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting
  ): zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly = new Wrapper(
    impl
  )
}
