package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  MaxResults,
  BotVersion,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListBotLocalesRequest(
    botId: Id,
    botVersion: BotVersion,
    sortBy: Optional[zio.aws.lexmodelsv2.model.BotLocaleSortBy] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.lexmodelsv2.model.BotLocaleFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest = {
    import ListBotLocalesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotLocalesRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotLocalesRequest.wrap(buildAwsValue())
}
object ListBotLocalesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotLocalesRequest =
      zio.aws.lexmodelsv2.model.ListBotLocalesRequest(
        botId,
        botVersion,
        sortBy.map(value => value.asEditable),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def botVersion: BotVersion
    def sortBy: Optional[zio.aws.lexmodelsv2.model.BotLocaleSortBy.ReadOnly]
    def filters
        : Optional[List[zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotLocaleSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest
  ) extends zio.aws.lexmodelsv2.model.ListBotLocalesRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
    override val sortBy
        : Optional[zio.aws.lexmodelsv2.model.BotLocaleSortBy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.lexmodelsv2.model.BotLocaleSortBy.wrap(value))
    override val filters
        : Optional[List[zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotLocaleFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest
  ): zio.aws.lexmodelsv2.model.ListBotLocalesRequest.ReadOnly = new Wrapper(
    impl
  )
}
