package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{KmsKeyArn, S3BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3BucketTranscriptSource(
    s3BucketName: S3BucketName,
    pathFormat: Optional[zio.aws.lexmodelsv2.model.PathFormat] =
      Optional.Absent,
    transcriptFormat: zio.aws.lexmodelsv2.model.TranscriptFormat,
    transcriptFilter: Optional[zio.aws.lexmodelsv2.model.TranscriptFilter] =
      Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.S3BucketTranscriptSource = {
    import S3BucketTranscriptSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.S3BucketTranscriptSource
      .builder()
      .s3BucketName(S3BucketName.unwrap(s3BucketName): java.lang.String)
      .optionallyWith(pathFormat.map(value => value.buildAwsValue()))(
        _.pathFormat
      )
      .transcriptFormat(transcriptFormat.unwrap)
      .optionallyWith(transcriptFilter.map(value => value.buildAwsValue()))(
        _.transcriptFilter
      )
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.S3BucketTranscriptSource.ReadOnly =
    zio.aws.lexmodelsv2.model.S3BucketTranscriptSource.wrap(buildAwsValue())
}
object S3BucketTranscriptSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.S3BucketTranscriptSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.S3BucketTranscriptSource =
      zio.aws.lexmodelsv2.model.S3BucketTranscriptSource(
        s3BucketName,
        pathFormat.map(value => value.asEditable),
        transcriptFormat,
        transcriptFilter.map(value => value.asEditable),
        kmsKeyArn.map(value => value)
      )
    def s3BucketName: S3BucketName
    def pathFormat: Optional[zio.aws.lexmodelsv2.model.PathFormat.ReadOnly]
    def transcriptFormat: zio.aws.lexmodelsv2.model.TranscriptFormat
    def transcriptFilter
        : Optional[zio.aws.lexmodelsv2.model.TranscriptFilter.ReadOnly]
    def kmsKeyArn: Optional[KmsKeyArn]
    def getS3BucketName: ZIO[Any, Nothing, S3BucketName] =
      ZIO.succeed(s3BucketName)
    def getPathFormat
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.PathFormat.ReadOnly] =
      AwsError.unwrapOptionField("pathFormat", pathFormat)
    def getTranscriptFormat
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.TranscriptFormat] =
      ZIO.succeed(transcriptFormat)
    def getTranscriptFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TranscriptFilter.ReadOnly
    ] = AwsError.unwrapOptionField("transcriptFilter", transcriptFilter)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.S3BucketTranscriptSource
  ) extends zio.aws.lexmodelsv2.model.S3BucketTranscriptSource.ReadOnly {
    override val s3BucketName: S3BucketName =
      zio.aws.lexmodelsv2.model.primitives.S3BucketName(impl.s3BucketName())
    override val pathFormat
        : Optional[zio.aws.lexmodelsv2.model.PathFormat.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathFormat())
        .map(value => zio.aws.lexmodelsv2.model.PathFormat.wrap(value))
    override val transcriptFormat: zio.aws.lexmodelsv2.model.TranscriptFormat =
      zio.aws.lexmodelsv2.model.TranscriptFormat.wrap(impl.transcriptFormat())
    override val transcriptFilter
        : Optional[zio.aws.lexmodelsv2.model.TranscriptFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptFilter())
        .map(value => zio.aws.lexmodelsv2.model.TranscriptFilter.wrap(value))
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.S3BucketTranscriptSource
  ): zio.aws.lexmodelsv2.model.S3BucketTranscriptSource.ReadOnly = new Wrapper(
    impl
  )
}
