package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  LocaleId,
  DraftBotVersion,
  Id
}
import scala.jdk.CollectionConverters.*
final case class UpdateBotRecommendationResponse(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[DraftBotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    botRecommendationStatus: Optional[
      zio.aws.lexmodelsv2.model.BotRecommendationStatus
    ] = Optional.Absent,
    botRecommendationId: Optional[Id] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    transcriptSourceSetting: Optional[
      zio.aws.lexmodelsv2.model.TranscriptSourceSetting
    ] = Optional.Absent,
    encryptionSetting: Optional[zio.aws.lexmodelsv2.model.EncryptionSetting] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse = {
    import UpdateBotRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(botRecommendationStatus.map(value => value.unwrap))(
        _.botRecommendationStatus
      )
      .optionallyWith(
        botRecommendationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.botRecommendationId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        transcriptSourceSetting.map(value => value.buildAwsValue())
      )(_.transcriptSourceSetting)
      .optionallyWith(encryptionSetting.map(value => value.buildAwsValue()))(
        _.encryptionSetting
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse
      .wrap(buildAwsValue())
}
object UpdateBotRecommendationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse =
      zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        botRecommendationStatus.map(value => value),
        botRecommendationId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        transcriptSourceSetting.map(value => value.asEditable),
        encryptionSetting.map(value => value.asEditable)
      )
    def botId: Optional[Id]
    def botVersion: Optional[DraftBotVersion]
    def localeId: Optional[LocaleId]
    def botRecommendationStatus
        : Optional[zio.aws.lexmodelsv2.model.BotRecommendationStatus]
    def botRecommendationId: Optional[Id]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def transcriptSourceSetting
        : Optional[zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly]
    def encryptionSetting
        : Optional[zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getBotRecommendationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotRecommendationStatus
    ] = AwsError.unwrapOptionField(
      "botRecommendationStatus",
      botRecommendationStatus
    )
    def getBotRecommendationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botRecommendationId", botRecommendationId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getTranscriptSourceSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transcriptSourceSetting",
      transcriptSourceSetting
    )
    def getEncryptionSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionSetting", encryptionSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[DraftBotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val botRecommendationStatus
        : Optional[zio.aws.lexmodelsv2.model.BotRecommendationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botRecommendationStatus())
        .map(value =>
          zio.aws.lexmodelsv2.model.BotRecommendationStatus.wrap(value)
        )
    override val botRecommendationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botRecommendationId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val transcriptSourceSetting
        : Optional[zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transcriptSourceSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.TranscriptSourceSetting.wrap(value)
        )
    override val encryptionSetting
        : Optional[zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionSetting())
        .map(value => zio.aws.lexmodelsv2.model.EncryptionSetting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse
  ): zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly =
    new Wrapper(impl)
}
