package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  IntentSignature,
  Timestamp,
  DraftBotVersion,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class UpdateIntentResponse(
    intentId: Optional[Id] = Optional.Absent,
    intentName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    parentIntentSignature: Optional[IntentSignature] = Optional.Absent,
    sampleUtterances: Optional[
      Iterable[zio.aws.lexmodelsv2.model.SampleUtterance]
    ] = Optional.Absent,
    dialogCodeHook: Optional[zio.aws.lexmodelsv2.model.DialogCodeHookSettings] =
      Optional.Absent,
    fulfillmentCodeHook: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings
    ] = Optional.Absent,
    slotPriorities: Optional[Iterable[zio.aws.lexmodelsv2.model.SlotPriority]] =
      Optional.Absent,
    intentConfirmationSetting: Optional[
      zio.aws.lexmodelsv2.model.IntentConfirmationSetting
    ] = Optional.Absent,
    intentClosingSetting: Optional[
      zio.aws.lexmodelsv2.model.IntentClosingSetting
    ] = Optional.Absent,
    inputContexts: Optional[Iterable[zio.aws.lexmodelsv2.model.InputContext]] =
      Optional.Absent,
    outputContexts: Optional[
      Iterable[zio.aws.lexmodelsv2.model.OutputContext]
    ] = Optional.Absent,
    kendraConfiguration: Optional[
      zio.aws.lexmodelsv2.model.KendraConfiguration
    ] = Optional.Absent,
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[DraftBotVersion] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent,
    initialResponseSetting: Optional[
      zio.aws.lexmodelsv2.model.InitialResponseSetting
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse = {
    import UpdateIntentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse
      .builder()
      .optionallyWith(
        intentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.intentId)
      .optionallyWith(
        intentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parentIntentSignature.map(value =>
          IntentSignature.unwrap(value): java.lang.String
        )
      )(_.parentIntentSignature)
      .optionallyWith(
        sampleUtterances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sampleUtterances)
      .optionallyWith(dialogCodeHook.map(value => value.buildAwsValue()))(
        _.dialogCodeHook
      )
      .optionallyWith(fulfillmentCodeHook.map(value => value.buildAwsValue()))(
        _.fulfillmentCodeHook
      )
      .optionallyWith(
        slotPriorities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slotPriorities)
      .optionallyWith(
        intentConfirmationSetting.map(value => value.buildAwsValue())
      )(_.intentConfirmationSetting)
      .optionallyWith(intentClosingSetting.map(value => value.buildAwsValue()))(
        _.intentClosingSetting
      )
      .optionallyWith(
        inputContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputContexts)
      .optionallyWith(
        outputContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputContexts)
      .optionallyWith(kendraConfiguration.map(value => value.buildAwsValue()))(
        _.kendraConfiguration
      )
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        initialResponseSetting.map(value => value.buildAwsValue())
      )(_.initialResponseSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateIntentResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateIntentResponse.wrap(buildAwsValue())
}
object UpdateIntentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateIntentResponse =
      zio.aws.lexmodelsv2.model.UpdateIntentResponse(
        intentId.map(value => value),
        intentName.map(value => value),
        description.map(value => value),
        parentIntentSignature.map(value => value),
        sampleUtterances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dialogCodeHook.map(value => value.asEditable),
        fulfillmentCodeHook.map(value => value.asEditable),
        slotPriorities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        intentConfirmationSetting.map(value => value.asEditable),
        intentClosingSetting.map(value => value.asEditable),
        inputContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kendraConfiguration.map(value => value.asEditable),
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        initialResponseSetting.map(value => value.asEditable)
      )
    def intentId: Optional[Id]
    def intentName: Optional[Name]
    def description: Optional[Description]
    def parentIntentSignature: Optional[IntentSignature]
    def sampleUtterances
        : Optional[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]]
    def dialogCodeHook
        : Optional[zio.aws.lexmodelsv2.model.DialogCodeHookSettings.ReadOnly]
    def fulfillmentCodeHook: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly
    ]
    def slotPriorities
        : Optional[List[zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly]]
    def intentConfirmationSetting
        : Optional[zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly]
    def intentClosingSetting
        : Optional[zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly]
    def inputContexts
        : Optional[List[zio.aws.lexmodelsv2.model.InputContext.ReadOnly]]
    def outputContexts
        : Optional[List[zio.aws.lexmodelsv2.model.OutputContext.ReadOnly]]
    def kendraConfiguration
        : Optional[zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly]
    def botId: Optional[Id]
    def botVersion: Optional[DraftBotVersion]
    def localeId: Optional[LocaleId]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def initialResponseSetting
        : Optional[zio.aws.lexmodelsv2.model.InitialResponseSetting.ReadOnly]
    def getIntentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("intentId", intentId)
    def getIntentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParentIntentSignature: ZIO[Any, AwsError, IntentSignature] =
      AwsError.unwrapOptionField("parentIntentSignature", parentIntentSignature)
    def getSampleUtterances: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly
    ]] = AwsError.unwrapOptionField("sampleUtterances", sampleUtterances)
    def getDialogCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.DialogCodeHookSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dialogCodeHook", dialogCodeHook)
    def getFulfillmentCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly
    ] = AwsError.unwrapOptionField("fulfillmentCodeHook", fulfillmentCodeHook)
    def getSlotPriorities: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly
    ]] = AwsError.unwrapOptionField("slotPriorities", slotPriorities)
    def getIntentConfirmationSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "intentConfirmationSetting",
      intentConfirmationSetting
    )
    def getIntentClosingSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly
    ] = AwsError.unwrapOptionField("intentClosingSetting", intentClosingSetting)
    def getInputContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.InputContext.ReadOnly
    ]] = AwsError.unwrapOptionField("inputContexts", inputContexts)
    def getOutputContexts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.OutputContext.ReadOnly
    ]] = AwsError.unwrapOptionField("outputContexts", outputContexts)
    def getKendraConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("kendraConfiguration", kendraConfiguration)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getInitialResponseSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.InitialResponseSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "initialResponseSetting",
      initialResponseSetting
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateIntentResponse.ReadOnly {
    override val intentId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.intentId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val intentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.intentName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val parentIntentSignature: Optional[IntentSignature] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentIntentSignature())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.IntentSignature(value)
        )
    override val sampleUtterances
        : Optional[List[zio.aws.lexmodelsv2.model.SampleUtterance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleUtterances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SampleUtterance.wrap(item)
          }.toList
        )
    override val dialogCodeHook
        : Optional[zio.aws.lexmodelsv2.model.DialogCodeHookSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dialogCodeHook())
        .map(value =>
          zio.aws.lexmodelsv2.model.DialogCodeHookSettings.wrap(value)
        )
    override val fulfillmentCodeHook: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fulfillmentCodeHook())
      .map(value =>
        zio.aws.lexmodelsv2.model.FulfillmentCodeHookSettings.wrap(value)
      )
    override val slotPriorities
        : Optional[List[zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotPriorities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SlotPriority.wrap(item)
          }.toList
        )
    override val intentConfirmationSetting: Optional[
      zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.intentConfirmationSetting())
      .map(value =>
        zio.aws.lexmodelsv2.model.IntentConfirmationSetting.wrap(value)
      )
    override val intentClosingSetting
        : Optional[zio.aws.lexmodelsv2.model.IntentClosingSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intentClosingSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.IntentClosingSetting.wrap(value)
        )
    override val inputContexts
        : Optional[List[zio.aws.lexmodelsv2.model.InputContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.InputContext.wrap(item)
          }.toList
        )
    override val outputContexts
        : Optional[List[zio.aws.lexmodelsv2.model.OutputContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.OutputContext.wrap(item)
          }.toList
        )
    override val kendraConfiguration
        : Optional[zio.aws.lexmodelsv2.model.KendraConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kendraConfiguration())
        .map(value => zio.aws.lexmodelsv2.model.KendraConfiguration.wrap(value))
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[DraftBotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val initialResponseSetting
        : Optional[zio.aws.lexmodelsv2.model.InitialResponseSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialResponseSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.InitialResponseSetting.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse
  ): zio.aws.lexmodelsv2.model.UpdateIntentResponse.ReadOnly = new Wrapper(impl)
}
