package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Transcript
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociatedTranscript(
    transcript: Optional[Transcript] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript = {
    import AssociatedTranscript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript
      .builder()
      .optionallyWith(
        transcript.map(value => Transcript.unwrap(value): java.lang.String)
      )(_.transcript)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AssociatedTranscript.ReadOnly =
    zio.aws.lexmodelsv2.model.AssociatedTranscript.wrap(buildAwsValue())
}
object AssociatedTranscript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AssociatedTranscript =
      zio.aws.lexmodelsv2.model
        .AssociatedTranscript(transcript.map(value => value))
    def transcript: Optional[Transcript]
    def getTranscript: ZIO[Any, AwsError, Transcript] =
      AwsError.unwrapOptionField("transcript", transcript)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript
  ) extends zio.aws.lexmodelsv2.model.AssociatedTranscript.ReadOnly {
    override val transcript: Optional[Transcript] = zio.aws.core.internal
      .optionalFromNullable(impl.transcript())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Transcript(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript
  ): zio.aws.lexmodelsv2.model.AssociatedTranscript.ReadOnly = new Wrapper(impl)
}
