package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.TimeInMilliSeconds
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AudioSpecification(
    maxLengthMs: TimeInMilliSeconds,
    endTimeoutMs: TimeInMilliSeconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AudioSpecification = {
    import AudioSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AudioSpecification
      .builder()
      .maxLengthMs(TimeInMilliSeconds.unwrap(maxLengthMs): Integer)
      .endTimeoutMs(TimeInMilliSeconds.unwrap(endTimeoutMs): Integer)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AudioSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.AudioSpecification.wrap(buildAwsValue())
}
object AudioSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AudioSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AudioSpecification =
      zio.aws.lexmodelsv2.model.AudioSpecification(maxLengthMs, endTimeoutMs)
    def maxLengthMs: TimeInMilliSeconds
    def endTimeoutMs: TimeInMilliSeconds
    def getMaxLengthMs: ZIO[Any, Nothing, TimeInMilliSeconds] =
      ZIO.succeed(maxLengthMs)
    def getEndTimeoutMs: ZIO[Any, Nothing, TimeInMilliSeconds] =
      ZIO.succeed(endTimeoutMs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AudioSpecification
  ) extends zio.aws.lexmodelsv2.model.AudioSpecification.ReadOnly {
    override val maxLengthMs: TimeInMilliSeconds =
      zio.aws.lexmodelsv2.model.primitives
        .TimeInMilliSeconds(impl.maxLengthMs())
    override val endTimeoutMs: TimeInMilliSeconds =
      zio.aws.lexmodelsv2.model.primitives
        .TimeInMilliSeconds(impl.endTimeoutMs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AudioSpecification
  ): zio.aws.lexmodelsv2.model.AudioSpecification.ReadOnly = new Wrapper(impl)
}
