package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConditionalSpecification(
    active: BoxedBoolean,
    conditionalBranches: Iterable[zio.aws.lexmodelsv2.model.ConditionalBranch],
    defaultBranch: zio.aws.lexmodelsv2.model.DefaultConditionalBranch
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ConditionalSpecification = {
    import ConditionalSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ConditionalSpecification
      .builder()
      .active(active: java.lang.Boolean)
      .conditionalBranches(conditionalBranches.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .defaultBranch(defaultBranch.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(buildAwsValue())
}
object ConditionalSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ConditionalSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ConditionalSpecification =
      zio.aws.lexmodelsv2.model.ConditionalSpecification(
        active,
        conditionalBranches.map { item =>
          item.asEditable
        },
        defaultBranch.asEditable
      )
    def active: BoxedBoolean
    def conditionalBranches
        : List[zio.aws.lexmodelsv2.model.ConditionalBranch.ReadOnly]
    def defaultBranch
        : zio.aws.lexmodelsv2.model.DefaultConditionalBranch.ReadOnly
    def getActive: ZIO[Any, Nothing, BoxedBoolean] = ZIO.succeed(active)
    def getConditionalBranches: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.ConditionalBranch.ReadOnly
    ]] = ZIO.succeed(conditionalBranches)
    def getDefaultBranch: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.DefaultConditionalBranch.ReadOnly
    ] = ZIO.succeed(defaultBranch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConditionalSpecification
  ) extends zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly {
    override val active: BoxedBoolean = impl.active(): BoxedBoolean
    override val conditionalBranches
        : List[zio.aws.lexmodelsv2.model.ConditionalBranch.ReadOnly] = impl
      .conditionalBranches()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.ConditionalBranch.wrap(item)
      }
      .toList
    override val defaultBranch
        : zio.aws.lexmodelsv2.model.DefaultConditionalBranch.ReadOnly =
      zio.aws.lexmodelsv2.model.DefaultConditionalBranch
        .wrap(impl.defaultBranch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ConditionalSpecification
  ): zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly = new Wrapper(
    impl
  )
}
