package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Name, BoxedBoolean}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ElicitationCodeHookInvocationSetting(
    enableCodeHookInvocation: BoxedBoolean,
    invocationLabel: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting = {
    import ElicitationCodeHookInvocationSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
      .builder()
      .enableCodeHookInvocation(enableCodeHookInvocation: java.lang.Boolean)
      .optionallyWith(
        invocationLabel.map(value => Name.unwrap(value): java.lang.String)
      )(_.invocationLabel)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
      .wrap(buildAwsValue())
}
object ElicitationCodeHookInvocationSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting =
      zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting(
        enableCodeHookInvocation,
        invocationLabel.map(value => value)
      )
    def enableCodeHookInvocation: BoxedBoolean
    def invocationLabel: Optional[Name]
    def getEnableCodeHookInvocation: ZIO[Any, Nothing, BoxedBoolean] =
      ZIO.succeed(enableCodeHookInvocation)
    def getInvocationLabel: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("invocationLabel", invocationLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
  ) extends zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly {
    override val enableCodeHookInvocation: BoxedBoolean =
      impl.enableCodeHookInvocation(): BoxedBoolean
    override val invocationLabel: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationLabel())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ElicitationCodeHookInvocationSetting
  ): zio.aws.lexmodelsv2.model.ElicitationCodeHookInvocationSetting.ReadOnly =
    new Wrapper(impl)
}
