package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  KmsKeyArn,
  S3ObjectPath,
  S3BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GrammarSlotTypeSource(
    s3BucketName: S3BucketName,
    s3ObjectKey: S3ObjectPath,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.GrammarSlotTypeSource = {
    import GrammarSlotTypeSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.GrammarSlotTypeSource
      .builder()
      .s3BucketName(S3BucketName.unwrap(s3BucketName): java.lang.String)
      .s3ObjectKey(S3ObjectPath.unwrap(s3ObjectKey): java.lang.String)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.GrammarSlotTypeSource.ReadOnly =
    zio.aws.lexmodelsv2.model.GrammarSlotTypeSource.wrap(buildAwsValue())
}
object GrammarSlotTypeSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.GrammarSlotTypeSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.GrammarSlotTypeSource =
      zio.aws.lexmodelsv2.model.GrammarSlotTypeSource(
        s3BucketName,
        s3ObjectKey,
        kmsKeyArn.map(value => value)
      )
    def s3BucketName: S3BucketName
    def s3ObjectKey: S3ObjectPath
    def kmsKeyArn: Optional[KmsKeyArn]
    def getS3BucketName: ZIO[Any, Nothing, S3BucketName] =
      ZIO.succeed(s3BucketName)
    def getS3ObjectKey: ZIO[Any, Nothing, S3ObjectPath] =
      ZIO.succeed(s3ObjectKey)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.GrammarSlotTypeSource
  ) extends zio.aws.lexmodelsv2.model.GrammarSlotTypeSource.ReadOnly {
    override val s3BucketName: S3BucketName =
      zio.aws.lexmodelsv2.model.primitives.S3BucketName(impl.s3BucketName())
    override val s3ObjectKey: S3ObjectPath =
      zio.aws.lexmodelsv2.model.primitives.S3ObjectPath(impl.s3ObjectKey())
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.GrammarSlotTypeSource
  ): zio.aws.lexmodelsv2.model.GrammarSlotTypeSource.ReadOnly = new Wrapper(
    impl
  )
}
