package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InitialResponseSetting(
    initialResponse: Optional[zio.aws.lexmodelsv2.model.ResponseSpecification] =
      Optional.Absent,
    nextStep: Optional[zio.aws.lexmodelsv2.model.DialogState] = Optional.Absent,
    conditional: Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification] =
      Optional.Absent,
    codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.InitialResponseSetting = {
    import InitialResponseSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.InitialResponseSetting
      .builder()
      .optionallyWith(initialResponse.map(value => value.buildAwsValue()))(
        _.initialResponse
      )
      .optionallyWith(nextStep.map(value => value.buildAwsValue()))(_.nextStep)
      .optionallyWith(conditional.map(value => value.buildAwsValue()))(
        _.conditional
      )
      .optionallyWith(codeHook.map(value => value.buildAwsValue()))(_.codeHook)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.InitialResponseSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.InitialResponseSetting.wrap(buildAwsValue())
}
object InitialResponseSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.InitialResponseSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.InitialResponseSetting =
      zio.aws.lexmodelsv2.model.InitialResponseSetting(
        initialResponse.map(value => value.asEditable),
        nextStep.map(value => value.asEditable),
        conditional.map(value => value.asEditable),
        codeHook.map(value => value.asEditable)
      )
    def initialResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly]
    def nextStep: Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly]
    def conditional
        : Optional[zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly]
    def codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ]
    def getInitialResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("initialResponse", initialResponse)
    def getNextStep
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      AwsError.unwrapOptionField("nextStep", nextStep)
    def getConditional: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("conditional", conditional)
    def getCodeHook: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ] = AwsError.unwrapOptionField("codeHook", codeHook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.InitialResponseSetting
  ) extends zio.aws.lexmodelsv2.model.InitialResponseSetting.ReadOnly {
    override val initialResponse
        : Optional[zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialResponse())
        .map(value =>
          zio.aws.lexmodelsv2.model.ResponseSpecification.wrap(value)
        )
    override val nextStep
        : Optional[zio.aws.lexmodelsv2.model.DialogState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextStep())
        .map(value => zio.aws.lexmodelsv2.model.DialogState.wrap(value))
    override val conditional: Optional[
      zio.aws.lexmodelsv2.model.ConditionalSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conditional())
      .map(value =>
        zio.aws.lexmodelsv2.model.ConditionalSpecification.wrap(value)
      )
    override val codeHook: Optional[
      zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.codeHook())
      .map(value =>
        zio.aws.lexmodelsv2.model.DialogCodeHookInvocationSetting.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.InitialResponseSetting
  ): zio.aws.lexmodelsv2.model.InitialResponseSetting.ReadOnly = new Wrapper(
    impl
  )
}
