package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  MaxResults,
  BotVersion,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListExportsRequest(
    botId: Optional[Id] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    sortBy: Optional[zio.aws.lexmodelsv2.model.ExportSortBy] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.lexmodelsv2.model.ExportFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest = {
    import ListExportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListExportsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListExportsRequest.wrap(buildAwsValue())
}
object ListExportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListExportsRequest =
      zio.aws.lexmodelsv2.model.ListExportsRequest(
        botId.map(value => value),
        botVersion.map(value => value),
        sortBy.map(value => value.asEditable),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        localeId.map(value => value)
      )
    def botId: Optional[Id]
    def botVersion: Optional[BotVersion]
    def sortBy: Optional[zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly]
    def filters: Optional[List[zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def localeId: Optional[LocaleId]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest
  ) extends zio.aws.lexmodelsv2.model.ListExportsRequest.ReadOnly {
    override val botId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val sortBy
        : Optional[zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.lexmodelsv2.model.ExportSortBy.wrap(value))
    override val filters
        : Optional[List[zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.ExportFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest
  ): zio.aws.lexmodelsv2.model.ListExportsRequest.ReadOnly = new Wrapper(impl)
}
