package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait SlotShape {
  def unwrap: software.amazon.awssdk.services.lexmodelsv2.model.SlotShape
}
object SlotShape {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.SlotShape
  ): zio.aws.lexmodelsv2.model.SlotShape = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotShape.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotShape.SCALAR =>
      val r = Scalar
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotShape.LIST =>
      val r = List
      r
  }
  case object unknownToSdkVersion extends zio.aws.lexmodelsv2.model.SlotShape {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotShape =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotShape.UNKNOWN_TO_SDK_VERSION
  }
  case object Scalar extends zio.aws.lexmodelsv2.model.SlotShape {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotShape =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotShape.SCALAR
  }
  case object List extends zio.aws.lexmodelsv2.model.SlotShape {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotShape =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotShape.LIST
  }
}
