package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{ImportExportFilePassword, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateExportRequest(
    exportId: Id,
    filePassword: Optional[ImportExportFilePassword] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest = {
    import UpdateExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest
      .builder()
      .exportId(Id.unwrap(exportId): java.lang.String)
      .optionallyWith(
        filePassword.map(value =>
          ImportExportFilePassword.unwrap(value): java.lang.String
        )
      )(_.filePassword)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateExportRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateExportRequest.wrap(buildAwsValue())
}
object UpdateExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateExportRequest =
      zio.aws.lexmodelsv2.model
        .UpdateExportRequest(exportId, filePassword.map(value => value))
    def exportId: Id
    def filePassword: Optional[ImportExportFilePassword]
    def getExportId: ZIO[Any, Nothing, Id] = ZIO.succeed(exportId)
    def getFilePassword: ZIO[Any, AwsError, ImportExportFilePassword] =
      AwsError.unwrapOptionField("filePassword", filePassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest
  ) extends zio.aws.lexmodelsv2.model.UpdateExportRequest.ReadOnly {
    override val exportId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.exportId())
    override val filePassword: Optional[ImportExportFilePassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filePassword())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ImportExportFilePassword(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest
  ): zio.aws.lexmodelsv2.model.UpdateExportRequest.ReadOnly = new Wrapper(impl)
}
