package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters.*
final case class UpdateExportResponse(
    exportId: Optional[Id] = Optional.Absent,
    resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification
    ] = Optional.Absent,
    fileFormat: Optional[zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      Optional.Absent,
    exportStatus: Optional[zio.aws.lexmodelsv2.model.ExportStatus] =
      Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse = {
    import UpdateExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse
      .builder()
      .optionallyWith(
        exportId.map(value => Id.unwrap(value): java.lang.String)
      )(_.exportId)
      .optionallyWith(
        resourceSpecification.map(value => value.buildAwsValue())
      )(_.resourceSpecification)
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateExportResponse.wrap(buildAwsValue())
}
object UpdateExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateExportResponse =
      zio.aws.lexmodelsv2.model.UpdateExportResponse(
        exportId.map(value => value),
        resourceSpecification.map(value => value.asEditable),
        fileFormat.map(value => value),
        exportStatus.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def exportId: Optional[Id]
    def resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ]
    def fileFormat: Optional[zio.aws.lexmodelsv2.model.ImportExportFileFormat]
    def exportStatus: Optional[zio.aws.lexmodelsv2.model.ExportStatus]
    def creationDateTime: Optional[Timestamp]
    def lastUpdatedDateTime: Optional[Timestamp]
    def getExportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("exportId", exportId)
    def getResourceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("resourceSpecification", resourceSpecification)
    def getFileFormat
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly {
    override val exportId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.exportId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val resourceSpecification: Optional[
      zio.aws.lexmodelsv2.model.ExportResourceSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.ExportResourceSpecification.wrap(value)
      )
    override val fileFormat
        : Optional[zio.aws.lexmodelsv2.model.ImportExportFileFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileFormat())
        .map(value =>
          zio.aws.lexmodelsv2.model.ImportExportFileFormat.wrap(value)
        )
    override val exportStatus
        : Optional[zio.aws.lexmodelsv2.model.ExportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportStatus())
        .map(value => zio.aws.lexmodelsv2.model.ExportStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDateTime())
        .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse
  ): zio.aws.lexmodelsv2.model.UpdateExportResponse.ReadOnly = new Wrapper(impl)
}
