package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  SkipResourceInUseCheck,
  LocaleId,
  DraftBotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteSlotTypeRequest(
    slotTypeId: Id,
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    skipResourceInUseCheck: Optional[SkipResourceInUseCheck] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest = {
    import DeleteSlotTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest
      .builder()
      .slotTypeId(Id.unwrap(slotTypeId): java.lang.String)
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .optionallyWith(
        skipResourceInUseCheck.map(value =>
          SkipResourceInUseCheck.unwrap(value): java.lang.Boolean
        )
      )(_.skipResourceInUseCheck)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteSlotTypeRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteSlotTypeRequest.wrap(buildAwsValue())
}
object DeleteSlotTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteSlotTypeRequest =
      zio.aws.lexmodelsv2.model.DeleteSlotTypeRequest(
        slotTypeId,
        botId,
        botVersion,
        localeId,
        skipResourceInUseCheck.map(value => value)
      )
    def slotTypeId: Id
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def skipResourceInUseCheck: Optional[SkipResourceInUseCheck]
    def getSlotTypeId: ZIO[Any, Nothing, Id] = ZIO.succeed(slotTypeId)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getSkipResourceInUseCheck: ZIO[Any, AwsError, SkipResourceInUseCheck] =
      AwsError.unwrapOptionField(
        "skipResourceInUseCheck",
        skipResourceInUseCheck
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteSlotTypeRequest.ReadOnly {
    override val slotTypeId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.slotTypeId())
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val skipResourceInUseCheck: Optional[SkipResourceInUseCheck] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skipResourceInUseCheck())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.SkipResourceInUseCheck(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest
  ): zio.aws.lexmodelsv2.model.DeleteSlotTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
