package zio.aws.lexmodelsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{FulfillmentTimeout, BoxedBoolean}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FulfillmentUpdatesSpecification(
    active: BoxedBoolean,
    startResponse: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification
    ] = Optional.Absent,
    updateResponse: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification
    ] = Optional.Absent,
    timeoutInSeconds: Optional[FulfillmentTimeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdatesSpecification = {
    import FulfillmentUpdatesSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdatesSpecification
      .builder()
      .active(active: java.lang.Boolean)
      .optionallyWith(startResponse.map(value => value.buildAwsValue()))(
        _.startResponse
      )
      .optionallyWith(updateResponse.map(value => value.buildAwsValue()))(
        _.updateResponse
      )
      .optionallyWith(
        timeoutInSeconds.map(value => FulfillmentTimeout.unwrap(value): Integer)
      )(_.timeoutInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification
      .wrap(buildAwsValue())
}
object FulfillmentUpdatesSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdatesSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification =
      zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification(
        active,
        startResponse.map(value => value.asEditable),
        updateResponse.map(value => value.asEditable),
        timeoutInSeconds.map(value => value)
      )
    def active: BoxedBoolean
    def startResponse: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification.ReadOnly
    ]
    def updateResponse: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification.ReadOnly
    ]
    def timeoutInSeconds: Optional[FulfillmentTimeout]
    def getActive: ZIO[Any, Nothing, BoxedBoolean] = ZIO.succeed(active)
    def getStartResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("startResponse", startResponse)
    def getUpdateResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("updateResponse", updateResponse)
    def getTimeoutInSeconds: ZIO[Any, AwsError, FulfillmentTimeout] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdatesSpecification
  ) extends zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly {
    override val active: BoxedBoolean = impl.active(): BoxedBoolean
    override val startResponse: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.startResponse())
      .map(value =>
        zio.aws.lexmodelsv2.model.FulfillmentStartResponseSpecification
          .wrap(value)
      )
    override val updateResponse: Optional[
      zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateResponse())
      .map(value =>
        zio.aws.lexmodelsv2.model.FulfillmentUpdateResponseSpecification
          .wrap(value)
      )
    override val timeoutInSeconds: Optional[FulfillmentTimeout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInSeconds())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.FulfillmentTimeout(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentUpdatesSpecification
  ): zio.aws.lexmodelsv2.model.FulfillmentUpdatesSpecification.ReadOnly =
    new Wrapper(impl)
}
