package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SlotSortBy(
    attribute: zio.aws.lexmodelsv2.model.SlotSortAttribute,
    order: zio.aws.lexmodelsv2.model.SortOrder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotSortBy = {
    import SlotSortBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotSortBy
      .builder()
      .attribute(attribute.unwrap)
      .order(order.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotSortBy.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotSortBy.wrap(buildAwsValue())
}
object SlotSortBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotSortBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotSortBy =
      zio.aws.lexmodelsv2.model.SlotSortBy(attribute, order)
    def attribute: zio.aws.lexmodelsv2.model.SlotSortAttribute
    def order: zio.aws.lexmodelsv2.model.SortOrder
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SlotSortAttribute] =
      ZIO.succeed(attribute)
    def getOrder: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.SortOrder] =
      ZIO.succeed(order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotSortBy
  ) extends zio.aws.lexmodelsv2.model.SlotSortBy.ReadOnly {
    override val attribute: zio.aws.lexmodelsv2.model.SlotSortAttribute =
      zio.aws.lexmodelsv2.model.SlotSortAttribute.wrap(impl.attribute())
    override val order: zio.aws.lexmodelsv2.model.SortOrder =
      zio.aws.lexmodelsv2.model.SortOrder.wrap(impl.order())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotSortBy
  ): zio.aws.lexmodelsv2.model.SlotSortBy.ReadOnly = new Wrapper(impl)
}
