package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SlotValueOverride(
    shape: Optional[zio.aws.lexmodelsv2.model.SlotShape] = Optional.Absent,
    value: Optional[zio.aws.lexmodelsv2.model.SlotValue] = Optional.Absent,
    values: Optional[Iterable[zio.aws.lexmodelsv2.model.SlotValueOverride]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride = {
    import SlotValueOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride
      .builder()
      .optionallyWith(shape.map(value => value.unwrap))(_.shape)
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotValueOverride.wrap(buildAwsValue())
}
object SlotValueOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotValueOverride =
      zio.aws.lexmodelsv2.model.SlotValueOverride(
        shape.map(value => value),
        value.map(value => value.asEditable),
        values.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def shape: Optional[zio.aws.lexmodelsv2.model.SlotShape]
    def value: Optional[zio.aws.lexmodelsv2.model.SlotValue.ReadOnly]
    def values
        : Optional[List[zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly]]
    def getShape: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SlotShape] =
      AwsError.unwrapOptionField("shape", shape)
    def getValue
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SlotValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getValues: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride
  ) extends zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly {
    override val shape: Optional[zio.aws.lexmodelsv2.model.SlotShape] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shape())
        .map(value => zio.aws.lexmodelsv2.model.SlotShape.wrap(value))
    override val value: Optional[zio.aws.lexmodelsv2.model.SlotValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.lexmodelsv2.model.SlotValue.wrap(value))
    override val values
        : Optional[List[zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.SlotValueOverride.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride
  ): zio.aws.lexmodelsv2.model.SlotValueOverride.ReadOnly = new Wrapper(impl)
}
