package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BotAliasLocaleSettings(
    enabled: Boolean,
    codeHookSpecification: Optional[
      zio.aws.lexmodelsv2.model.CodeHookSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettings = {
    import BotAliasLocaleSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettings
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        codeHookSpecification.map(value => value.buildAwsValue())
      )(_.codeHookSpecification)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly =
    zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.wrap(buildAwsValue())
}
object BotAliasLocaleSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotAliasLocaleSettings =
      zio.aws.lexmodelsv2.model.BotAliasLocaleSettings(
        enabled,
        codeHookSpecification.map(value => value.asEditable)
      )
    def enabled: Boolean
    def codeHookSpecification
        : Optional[zio.aws.lexmodelsv2.model.CodeHookSpecification.ReadOnly]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getCodeHookSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.CodeHookSpecification.ReadOnly
    ] =
      AwsError.unwrapOptionField("codeHookSpecification", codeHookSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettings
  ) extends zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val codeHookSpecification
        : Optional[zio.aws.lexmodelsv2.model.CodeHookSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeHookSpecification())
        .map(value =>
          zio.aws.lexmodelsv2.model.CodeHookSpecification.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotAliasLocaleSettings
  ): zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly = new Wrapper(
    impl
  )
}
