package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BotLocaleFilter(
    name: zio.aws.lexmodelsv2.model.BotLocaleFilterName,
    values: Iterable[FilterValue],
    operator: zio.aws.lexmodelsv2.model.BotLocaleFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleFilter = {
    import BotLocaleFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.BotLocaleFilter.wrap(buildAwsValue())
}
object BotLocaleFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotLocaleFilter =
      zio.aws.lexmodelsv2.model.BotLocaleFilter(name, values, operator)
    def name: zio.aws.lexmodelsv2.model.BotLocaleFilterName
    def values: List[FilterValue]
    def operator: zio.aws.lexmodelsv2.model.BotLocaleFilterOperator
    def getName
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.BotLocaleFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.BotLocaleFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleFilter
  ) extends zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.BotLocaleFilterName =
      zio.aws.lexmodelsv2.model.BotLocaleFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
    override val operator: zio.aws.lexmodelsv2.model.BotLocaleFilterOperator =
      zio.aws.lexmodelsv2.model.BotLocaleFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleFilter
  ): zio.aws.lexmodelsv2.model.BotLocaleFilter.ReadOnly = new Wrapper(impl)
}
