package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  Description,
  BotVersion,
  Name
}
import scala.jdk.CollectionConverters.*
final case class BotVersionSummary(
    botName: Optional[Name] = Optional.Absent,
    botVersion: Optional[BotVersion] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] = Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary = {
    import BotVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary
      .builder()
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BotVersionSummary.wrap(buildAwsValue())
}
object BotVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotVersionSummary =
      zio.aws.lexmodelsv2.model.BotVersionSummary(
        botName.map(value => value),
        botVersion.map(value => value),
        description.map(value => value),
        botStatus.map(value => value),
        creationDateTime.map(value => value)
      )
    def botName: Optional[Name]
    def botVersion: Optional[BotVersion]
    def description: Optional[Description]
    def botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus]
    def creationDateTime: Optional[Timestamp]
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary
  ) extends zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly {
    override val botName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.botName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val botVersion: Optional[BotVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botStatus: Optional[zio.aws.lexmodelsv2.model.BotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botStatus())
        .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary
  ): zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly = new Wrapper(impl)
}
