package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteImportRequest(importId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest = {
    import DeleteImportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest
      .builder()
      .importId(Id.unwrap(importId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteImportRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteImportRequest.wrap(buildAwsValue())
}
object DeleteImportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteImportRequest =
      zio.aws.lexmodelsv2.model.DeleteImportRequest(importId)
    def importId: Id
    def getImportId: ZIO[Any, Nothing, Id] = ZIO.succeed(importId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteImportRequest.ReadOnly {
    override val importId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.importId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest
  ): zio.aws.lexmodelsv2.model.DeleteImportRequest.ReadOnly = new Wrapper(impl)
}
